/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.date;

import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class P2DateFactory {
    public static String getTodayStr() {
        return new P2Date().getDateTime(P2DateConst.F_FORMAT_dd_MM_yyyy);
    }

    public static String getTodayInverseStr() {
        return new P2Date().getDateTime(P2DateConst.F_FORMAT_yyyy_MM_dd);
    }

    public static P2Date getToday() {
        P2Date p2Date = new P2Date();
        p2Date.setPDateToday();
        return p2Date;
    }

    public static P2Date getYesterday() {
        LocalDate pDate = LocalDate.now().minusDays(1L);
        ZoneId defaultZoneId = ZoneId.systemDefault();
        return new P2Date(Date.from(pDate.atStartOfDay(defaultZoneId).toInstant()));
    }

    public static String getAktYearStr() {
        return "" + LocalDate.now().getYear();
    }

    public static int getActYearInt() {
        return LocalDate.now().getYear();
    }

    public static int getYearIntFromString(String year) {
        int ret;
        try {
            long y = P2DateConst.F_FORMAT_yyyy.parse(year).getTime();
            ret = Integer.parseInt(year);
        }
        catch (Exception ex) {
            ret = 0;
            P2Log.errorLog(621212154, "Jahr: " + year);
        }
        return ret;
    }

    public static List<String> getYearListSince(String year) {
        ArrayList<String> list = new ArrayList<String>();
        int aktYear = P2DateFactory.getActYearInt();
        int startCheckYear = P2DateFactory.getYearIntFromString(year);
        if (startCheckYear <= 0 || aktYear < startCheckYear) {
            return list;
        }
        while (startCheckYear <= aktYear) {
            list.add("" + startCheckYear);
            ++startCheckYear;
        }
        return list;
    }

    public static List<Integer> getYearListSince(int year) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int aktYear = P2DateFactory.getActYearInt();
        int startCheckYear = P2DateFactory.getYearIntFromString("" + year);
        if (startCheckYear <= 0 || aktYear < startCheckYear) {
            return list;
        }
        while (startCheckYear <= aktYear) {
            list.add(startCheckYear);
            ++startCheckYear;
        }
        return list;
    }

    public static LocalDate getLocalDate(String strDate) {
        if (strDate == null || strDate.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_dd_MM_yyyy);
        }
        catch (Exception exception) {
            try {
                return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_d_MM_yyyy);
            }
            catch (Exception exception2) {
                try {
                    return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_dd_M_yyyy);
                }
                catch (Exception exception3) {
                    try {
                        return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_d_M_yyyy);
                    }
                    catch (Exception exception4) {
                        try {
                            return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_EEE_MMM_dd_);
                        }
                        catch (Exception exception5) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    public static int diffInSeconds(Date date) {
        int ret = (int)(1L * (date.getTime() - new Date().getTime()) / 1000L);
        return Math.abs(ret);
    }

    public static String toString(P2Date p2Date) {
        if (p2Date == null) {
            return "";
        }
        return p2Date.getDateTime(P2DateConst.F_FORMAT_dd_MM_yyyy);
    }

    public static String toStringR(P2Date p2Date) {
        if (p2Date == null) {
            return "";
        }
        return p2Date.getDateTime(P2DateConst.F_FORMAT_yyyy_MM_dd);
    }
}

