/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.date;

import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.date.P2DateFactory;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.LocalDate;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class P2Date
extends Date {
    public P2Date() {
    }

    public P2Date(Date date) {
        super(date.getTime());
    }

    public P2Date(long l) {
        super(l);
    }

    public P2Date(String date) {
        this.setPDate(date);
    }

    public P2Date(String date, String time) {
        this.setPDate(date, time);
    }

    public void setPDate(P2Date p2Date) {
        this.setTime(p2Date.getTime());
    }

    public void setPDate(String strDate) {
        this.setPDate(strDate, "");
    }

    public void setPDate(String strDate, String strTime, FastDateFormat dateF, FastDateFormat timeF) {
        if (strDate.isEmpty()) {
            this.setTime(0L);
            return;
        }
        try {
            if (strTime.isEmpty()) {
                this.setTime(dateF.parse(strDate).getTime());
            } else {
                this.setTime(timeF.parse(strDate + strTime).getTime());
            }
            return;
        }
        catch (Exception exception) {
            this.setTime(0L);
            return;
        }
    }

    public void setPDate(String strDate, FastDateFormat dateF) {
        if (strDate.isEmpty()) {
            this.setTime(0L);
            return;
        }
        try {
            this.setTime(dateF.parse(strDate).getTime());
            return;
        }
        catch (Exception exception) {
            this.setTime(0L);
            return;
        }
    }

    public void setPDate(String strDate, String strTime) {
        if (strDate.isEmpty()) {
            this.setTime(0L);
            return;
        }
        try {
            if (strTime.isEmpty()) {
                this.setTime(P2DateConst.F_FORMAT_dd_MM_yyyy.parse(strDate).getTime());
            } else {
                this.setTime(P2DateConst.F_FORMAT_dd_MM_yyyyKomma___HH_mm.parse(strDate + strTime).getTime());
            }
            return;
        }
        catch (Exception exception) {
            try {
                if (strTime.isEmpty()) {
                    this.setTime(P2DateConst.F_FORMAT_dd_MM_yyyy.parse(strDate).getTime());
                } else {
                    this.setTime(P2DateConst.F_FORMAT_dd_MM_yyyyKomma___HH_mm_ss.parse(strDate + strTime).getTime());
                }
                return;
            }
            catch (Exception ex) {
                P2Log.errorLog(952103654, ex, new String[]{"Datum: " + strDate, "Zeit: " + strTime});
                this.setTime(0L);
                return;
            }
        }
    }

    public LocalDate getLocalDate() {
        String strDate = this.toString();
        if (strDate == null || strDate.isEmpty()) {
            return null;
        }
        try {
            return P2LDateFactory.fromString(strDate);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clearPDate() {
        this.setTime(0L);
    }

    public boolean isEmpty() {
        return this.getTime() == 0L;
    }

    public void setPDateToday() {
        try {
            String strToday = new P2Date().getDateTime(P2DateConst.F_FORMAT_dd_MM_yyyy);
            long lToday = P2DateConst.F_FORMAT_dd_MM_yyyy.parse(strToday).getTime();
            this.setTime(lToday);
        }
        catch (Exception ex) {
            this.setTime(0L);
            P2Log.errorLog(915263630, ex);
        }
    }

    public void setPDateNow() {
        try {
            this.setTime(new P2Date().getTime());
        }
        catch (Exception ex) {
            this.setTime(0L);
            P2Log.errorLog(915263630, ex);
        }
    }

    public String getDateTime(FastDateFormat format) {
        if (this.getTime() == 0L) {
            return "";
        }
        return format.format(this);
    }

    public String get_yyyy_MM_dd() {
        if (this.getTime() == 0L) {
            return P2DateConst.F_FORMAT_yyyy_MM_dd.format(new Date());
        }
        return P2DateConst.F_FORMAT_yyyy_MM_dd.format(this);
    }

    public String get_dd_MM_yyyy() {
        if (this.getTime() == 0L) {
            return P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
        }
        return P2DateConst.F_FORMAT_dd_MM_yyyy.format(this);
    }

    public int diffInSeconds() {
        int ret = (int)(1L * (this.getTime() - new P2Date().getTime()) / 1000L);
        return Math.abs(ret);
    }

    public int diffInMinutes() {
        return this.diffInSeconds() / 60;
    }

    @Override
    public String toString() {
        return P2DateFactory.toString(this);
    }

    public String toStringR() {
        return P2DateFactory.toStringR(this);
    }
}

