/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.scene.Scene;

public class IoReadWriteStyle {
    public static String STYLE_START = "/* Programm weites style sheet */\n\n";
    public static String STYLE = ".root {\n  -fx-font-size: ##pt ;\n}\n";
    public static String STYLE_END = "\n";
    private static final ArrayList<String> list = new ArrayList();

    private IoReadWriteStyle() {
    }

    public static boolean readStyle(Path filePath, Scene scene) {
        boolean ret = IoReadWriteStyle.readData(filePath, scene);
        P2Log.sysLog(list);
        list.clear();
        return ret;
    }

    public static synchronized void writeStyle(Path filePath, int size) {
        IoReadWriteStyle.writeData(filePath, size);
        P2Log.sysLog(list);
        list.clear();
    }

    private static boolean readData(Path filePath, Scene scene) {
        P2Duration.counterStart("Style lesen");
        list.add("Start Lesen von: " + String.valueOf(filePath.toAbsolutePath()));
        boolean ret = false;
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                scene.getStylesheets().removeAll((String[])new String[]{filePath.toUri().toString()});
                scene.getStylesheets().add(filePath.toUri().toString());
                ret = true;
            }
            catch (NullPointerException ex) {
                P2Log.errorLog(987549987, "style.css not found");
            }
        }
        list.add("gelesen!");
        P2Duration.counterStop("Style lesen");
        return ret;
    }

    private static void writeData(Path filePath, int size) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(filePath, new OpenOption[0]), StandardCharsets.UTF_8));){
            list.add("Start Schreiben nach: " + String.valueOf(filePath.toAbsolutePath()));
            Object style = STYLE_START;
            if (size > 0) {
                style = (String)style + STYLE.replace("##", "" + size);
            }
            style = (String)style + STYLE_END;
            bufferedWriter.write((String)style);
            list.add("geschrieben!");
        }
        catch (Exception ex) {
            P2Log.errorLog(987010268, ex);
        }
    }
}

