/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtfilter;

import java.util.regex.Pattern;

public class Filter {
    public static String FILTER_REG_EX = "#:";
    public static String FILTER_EXCLUDE = "!:";
    public String filter = "";
    public String[] filterArr = new String[]{""};
    public boolean isFilterAnd = false;
    public boolean isExact = false;
    public Pattern pattern = null;
    public boolean isEmpty = true;
    public boolean isQuick = false;
    public boolean exclude = false;

    public Filter() {
    }

    public Filter(String filter, boolean makeArr) {
        this.filter = filter.trim();
        this.filterArr = new String[]{this.filter};
        if (makeArr) {
            this.makeFilterArray();
        } else {
            this.makeFilter();
        }
    }

    public Filter(String filter, boolean isExact, boolean makeArr) {
        this.filter = filter.trim();
        this.filterArr = new String[]{this.filter};
        this.isExact = isExact;
        if (makeArr) {
            this.makeFilterArray();
        } else {
            this.makeFilter();
        }
    }

    public void makeFilterArray() {
        if (this.filter.isEmpty()) {
            this.filterArr = new String[]{""};
            this.pattern = null;
            this.isEmpty = true;
            return;
        }
        this.setValues();
        if (this.pattern != null) {
            this.filterArr = new String[]{this.filter};
        } else if (this.isExact) {
            this.filterArr = new String[]{this.filter.trim().toLowerCase()};
            this.isQuick = true;
        } else {
            if (this.filter.trim().startsWith("\"") && this.filter.trim().endsWith("\"") && this.filter.length() > 1) {
                this.filterArr = new String[]{this.filter.substring(1, this.filter.length() - 1)};
            } else if (this.filter.contains(":")) {
                this.isFilterAnd = true;
                this.filterArr = this.filter.split(":");
            } else {
                this.isFilterAnd = false;
                this.filterArr = this.filter.split(",");
            }
            for (int i = 0; i < this.filterArr.length; ++i) {
                this.filterArr[i] = this.filterArr[i].trim().toLowerCase();
            }
            if (this.filterArr.length == 1) {
                this.isQuick = true;
            }
        }
        this.checkArray();
    }

    public void makeFilter() {
        if (this.filter.isEmpty()) {
            this.filterArr = new String[]{""};
            this.pattern = null;
            this.isEmpty = true;
            return;
        }
        this.setValues();
        if (this.pattern != null) {
            this.filterArr = new String[]{this.filter};
        } else {
            this.filterArr = new String[]{this.filter.trim().toLowerCase()};
            this.isQuick = true;
        }
        this.checkArray();
    }

    private void setValues() {
        this.isEmpty = false;
        this.isQuick = false;
        this.pattern = Filter.makePattern(this.filter);
        this.exclude = Filter.isExclusion(this.filter);
        if (this.exclude) {
            this.filter = this.filter.substring(FILTER_EXCLUDE.length());
        }
    }

    private void checkArray() {
        if (this.filterArr == null || this.filterArr.length == 0) {
            this.filterArr = new String[]{""};
            this.pattern = null;
            this.isEmpty = true;
        }
    }

    public static Pattern makePattern(String filter) {
        Pattern p = null;
        try {
            if (Filter.isPattern(filter)) {
                p = Pattern.compile(filter.substring(FILTER_REG_EX.length()), 98);
            }
        }
        catch (Exception ex) {
            p = null;
        }
        return p;
    }

    public static boolean isPattern(String searchText) {
        return searchText.startsWith(FILTER_REG_EX);
    }

    public static boolean isExclusion(String searchText) {
        return searchText.startsWith(FILTER_EXCLUDE);
    }
}

