/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtfilm.tools;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.StringConverter;
import javafx.util.converter.BooleanStringConverter;
import javafx.util.converter.NumberStringConverter;

public class MLConfigs {
    private final String key;
    private final String initValue;
    private final StringProperty actValue;

    public MLConfigs(String key) {
        this.key = key;
        this.initValue = "";
        this.actValue = new SimpleStringProperty(this.initValue);
    }

    public MLConfigs(String key, String init) {
        this.key = key;
        this.initValue = init;
        this.actValue = new SimpleStringProperty(this.initValue);
    }

    public MLConfigs(String key, int init) {
        this.key = key;
        this.initValue = String.valueOf(init);
        this.actValue = new SimpleStringProperty(this.initValue);
    }

    public MLConfigs(String key, boolean init) {
        this.key = key;
        this.initValue = String.valueOf(init);
        this.actValue = new SimpleStringProperty(this.initValue);
    }

    public synchronized void setValue(String value) {
        this.actValue.setValue(value == null ? "" : value);
    }

    public synchronized void setValue(boolean value) {
        this.actValue.setValue(String.valueOf(value));
    }

    public synchronized void setValue(int value) {
        this.actValue.setValue(String.valueOf(value));
    }

    public synchronized void setValue(long value) {
        this.actValue.setValue(String.valueOf(value));
    }

    public synchronized String get() {
        return this.actValue.getValueSafe();
    }

    public synchronized int getInt() {
        int ret;
        try {
            ret = Integer.parseInt(this.actValue.getValue());
        }
        catch (Exception ignore) {
            this.actValue.setValue("0");
            ret = 0;
        }
        return ret;
    }

    public synchronized long getLong() {
        long ret;
        try {
            ret = Long.parseLong(this.actValue.getValue());
        }
        catch (Exception ignore) {
            this.actValue.setValue("0");
            ret = 0L;
        }
        return ret;
    }

    public synchronized double getDouble() {
        double ret;
        try {
            String s = this.actValue.getValue();
            ret = Double.parseDouble(s);
        }
        catch (Exception ignore) {
            this.actValue.setValue("0");
            ret = 0.0;
        }
        return ret;
    }

    public synchronized boolean getBool() {
        return Boolean.parseBoolean(this.actValue.getValueSafe());
    }

    public synchronized StringProperty getStringProperty() {
        return this.actValue;
    }

    public synchronized BooleanProperty getBooleanProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleBooleanProperty ip = new SimpleBooleanProperty();
        try {
            ip.setValue(Boolean.parseBoolean(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue(Boolean.TRUE.toString());
            ip.setValue(true);
        }
        BooleanStringConverter converter = new BooleanStringConverter();
        Bindings.bindBidirectional((Property<String>)sp, ip, converter);
        return ip;
    }

    public IntegerProperty getIntegerProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleIntegerProperty ip = new SimpleIntegerProperty();
        try {
            ip.setValue(Integer.parseInt(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue("0");
            ip.setValue(0);
        }
        NumberStringConverter converter = new NumberStringConverter(new DecimalFormat("##"));
        Bindings.bindBidirectional((Property<String>)sp, ip, converter);
        return ip;
    }

    public synchronized DoubleProperty getDoubleProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleDoubleProperty dp = new SimpleDoubleProperty();
        try {
            dp.setValue(Double.parseDouble(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue("0");
            dp.setValue(0);
        }
        Locale locale = new Locale("en", "US");
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        final DecimalFormat df = (DecimalFormat)nf;
        Bindings.bindBidirectional((Property<String>)sp, dp, new StringConverter<Number>(){

            @Override
            public String toString(Number object) {
                return object == null ? "0" : df.format(object);
            }

            @Override
            public Number fromString(String string) {
                return string != null && !string.isEmpty() ? Double.valueOf(string) : 0.0;
            }
        });
        return dp;
    }

    public String getKey() {
        return this.key;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public StringProperty getActValue() {
        return this.actValue;
    }
}

