/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtfilm.film;

import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.mtfilm.film.FilmDataProps;
import de.p2tools.p2lib.mtfilm.film.FilmlistFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class Filmlist<T extends FilmData>
extends SimpleListProperty<T> {
    public int nr = 1;
    public String[] metaData = new String[]{"", "", "", "", ""};
    public String[] sender = new String[]{""};
    int count = 0;
    int countDouble = 0;
    FilteredList<T> filteredList = null;
    SortedList<T> sortedList = null;

    public Filmlist() {
        super(FXCollections.observableArrayList());
    }

    public <T extends FilmData> FilmData getNewElement() {
        return new FilmData();
    }

    public static synchronized String genDate(String[] metaData) {
        return FilmlistFactory.genDate(metaData);
    }

    public void clearFilteredList() {
        this.initFilterdList();
        this.filteredList.clear();
        this.sortedList.clear();
    }

    public SortedList<? extends FilmData> getSortedList() {
        this.initFilterdList();
        return this.sortedList;
    }

    public FilteredList<? extends FilmData> getFilteredList() {
        this.initFilterdList();
        return this.filteredList;
    }

    private void initFilterdList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<FilmData>(this, p -> true);
            this.sortedList = new SortedList<T>(this.filteredList);
        }
    }

    public synchronized void filteredListSetPred(Predicate<FilmData> predicate) {
        P2Log.debugLog("=================> Filter: " + ++this.count);
        P2Duration.counterStart("FilmList.filteredListSetPred");
        this.getFilteredList().setPredicate(predicate);
        P2Duration.counterStop("FilmList.filteredListSetPred");
    }

    public String getFilmlistId() {
        return this.metaData[4];
    }

    public synchronized boolean importFilmOnlyWithNr(T film) {
        ((FilmData)film).no = this.nr++;
        return this.add(film);
    }

    private void addHash(FilmData f, HashSet<String> hash, boolean index) {
        if (f.arr[1].equals("KiKA")) {
            hash.add(f.arr[2] + f.arr[3]);
        } else if (index) {
            hash.add(f.getIndex());
        } else {
            hash.add(f.getUrlForHash());
        }
    }

    public synchronized void updateList(Filmlist addList, boolean index, boolean replace) {
        FilmlistFactory.updateList(this, addList, index, replace);
    }

    public synchronized void markGeoBlocked() {
        this.parallelStream().forEach(f -> f.setGeoBlocked());
    }

    public synchronized int markFilms() {
        return FilmlistFactory.markFilms(this);
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        super.clear();
    }

    public synchronized void sort() {
        Collections.sort(this);
        int i = 1;
        for (FilmData film : this) {
            film.no = i++;
        }
    }

    public synchronized void setMeta(Filmlist filmlist) {
        System.arraycopy(filmlist.metaData, 0, this.metaData, 0, 5);
    }

    public synchronized T getFilmByUrl(String url) {
        Optional<FilmData> opt = this.parallelStream().filter(f -> f.arr[14].equalsIgnoreCase(url)).findAny();
        return (T)((FilmData)opt.orElse(null));
    }

    public synchronized void getTheme(String sender, LinkedList<String> list) {
        this.stream().filter(film -> film.arr[1].equals(sender)).filter(film -> !list.contains(film.arr[2])).forEach(film -> list.add(film.arr[2]));
    }

    public synchronized FilmData getFilmByUrl_small_high_hd(String url) {
        return this.parallelStream().filter(f -> f.arr[14].equals(url) || f.getUrlForResolution("hd").equals(url) || f.getUrlForResolution("small").equals(url)).findFirst().orElse(null);
    }

    public synchronized String genDate() {
        return Filmlist.genDate(this.metaData);
    }

    public int getAge() {
        return FilmlistFactory.getAge(this.metaData);
    }

    public static Date getAgeAsDate(String[] metaData) {
        return FilmlistFactory.getAgeAsDate(metaData);
    }

    public static String getAgeAsStringDate(String[] metaData) {
        return FilmlistFactory.getAgeAsStringDate(metaData);
    }

    public synchronized boolean isTooOldOrEmpty() {
        return FilmlistFactory.isTooOldOrEmpty(this, this.metaData);
    }

    public synchronized boolean isTooOldForDiffOrEmpty() {
        return FilmlistFactory.isTooOldForDiffOrEmpty(this, this.metaData);
    }

    public boolean isOlderThan(int second) {
        return FilmlistFactory.isOlderThan(this.metaData, second);
    }

    public synchronized long countNewFilms() {
        return this.stream().filter(FilmDataProps::isNewFilm).count();
    }

    public synchronized void loadSender() {
        P2Duration.counterStart("loadSender");
        LinkedHashSet<String> senderSet = new LinkedHashSet<String>(21);
        senderSet.add("");
        this.stream().forEach(film -> senderSet.add(film.getChannel()));
        this.sender = senderSet.toArray(new String[senderSet.size()]);
        P2Duration.counterStop("loadSender");
    }
}

