/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtfilm.film;

import de.p2tools.p2lib.mtdownload.DownloadFactory;
import de.p2tools.p2lib.mtfilm.film.FilmData;
import de.p2tools.p2lib.tools.DiacriticFactory;
import de.p2tools.p2lib.tools.DiacriticFactory3;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.beans.property.SimpleListProperty;

public class FilmFactory {
    static final String regEx1 = "[\\n\\r]";
    static final String regEx2 = "[\\p{Cc}&&[^\\t\\n\\r]]";
    private static Map<Character, Integer> counterMap = new HashMap<Character, Integer>(25);
    public static final String THEME_LIVE = "Livestream";
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);

    public static String getSizeFromWeb(FilmData film, String url) {
        if (url.equals(film.arr[14])) {
            return film.arr[9];
        }
        return DownloadFactory.getContentLengthMB(url);
    }

    public static void cleanFaultyCharacterFilmlist(SimpleListProperty<? extends FilmData> filmlist) {
        P2Duration.counterStart("cleanFaultyCharacterFilmlist");
        filmlist.stream().forEach(film -> {
            film.arr[3] = FilmFactory.clean_1(film.getTitle(), true);
            film.arr[2] = FilmFactory.clean_1(film.getTheme(), true);
            film.setDescription(FilmFactory.clean_1(film.getDescription(), false));
            film.arr[3] = FilmFactory.clean_2(film.getTitle());
            film.arr[2] = FilmFactory.clean_2(film.getTheme());
            film.setDescription(FilmFactory.clean_2(film.getDescription()));
        });
        for (Map.Entry<Character, Integer> entry : counterMap.entrySet()) {
            Character key = entry.getKey();
            Integer value = entry.getValue();
            P2Log.sysLog("Key: " + key.charValue() + "  Key: " + key + "  Anz: " + value);
        }
        P2Duration.counterStop("cleanFaultyCharacterFilmlist");
    }

    public static void flattenDiacritic(FilmData filmData) {
        filmData.arr[3] = DiacriticFactory.flattenDiacritic(filmData.getTitle());
        filmData.arr[2] = DiacriticFactory.flattenDiacritic(filmData.getTheme());
        filmData.setDescription(DiacriticFactory.flattenDiacritic(filmData.getDescription()));
    }

    public static void flattenDiacritic(SimpleListProperty<? extends FilmData> filmlist) {
        String test = "f\u0336\u0336a\u0336\u0336u\u0336\u0336l\u0336\u0336 Wer \"You\u00b4ll -\u00e4-\u00f6-\u00fc- alone\".......................................";
        P2Duration.counterStart("flattenDiacritic");
        filmlist.forEach(filmData -> {
            filmData.arr[3] = DiacriticFactory3.flattenDiacritic(filmData.getTitle());
            filmData.arr[2] = DiacriticFactory3.flattenDiacritic(filmData.getTheme());
            filmData.arr[12] = DiacriticFactory3.flattenDiacritic(filmData.getDescription());
        });
        P2Duration.counterStop("flattenDiacritic");
    }

    public static String cleanUnicode(String ret) {
        return FilmFactory.clean_1(ret, true);
    }

    private static String clean_1(String ret, boolean alsoNewLine) {
        ret = alsoNewLine ? ret.replaceAll(regEx1, " ").replaceAll(regEx2, "") : ret.replaceAll(regEx2, "");
        return ret;
    }

    private static String clean_2(String test) {
        char[] c = test.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] <= '\u2bff') continue;
            counterMap.merge(Character.valueOf(c[i]), 1, Integer::sum);
            c[i] = 32;
            test = String.valueOf(c);
        }
        return test;
    }
}

