/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtfilm.film;

import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.pdata.P2Data;
import de.p2tools.p2lib.mtfilm.film.FilmDataProps;
import de.p2tools.p2lib.mtfilm.tools.FilmDate;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class FilmData
extends FilmDataProps
implements P2Data {
    public String FILM_CHANNEL_STR = "";
    public String FILM_THEME_STR = "";
    public String FILM_TITLE_STR = "";
    public static final String RESOLUTION_ASK = "ask";
    public static final String RESOLUTION_NORMAL = "normal";
    public static final String RESOLUTION_HD = "hd";
    public static final String RESOLUTION_SMALL = "small";
    public static final int FILM_TIME_EMPTY = -1;
    public static final String GEO_DE = "DE";
    public static final String GEO_FR = "FR";
    public static final String GEO_AT = "AT";
    public static final String GEO_CH = "CH";
    public static final String GEO_EU = "EU";
    public static final String GEO_WELT = "WELT";

    @Override
    public String getTag() {
        return "";
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public Config[] getConfigsArr() {
        return null;
    }

    public void init() {
        this.setLive(this.arr[2].equals("Livestream"));
        this.setHd(!this.arr[19].isEmpty());
        this.setSmall(!this.arr[18].isEmpty());
        this.setUt(!this.arr[17].isEmpty());
        this.preserveMemory();
        this.filmSize.setFilmSize(this);
        this.setFilmLength();
        this.setDatum();
        this.setFilmTime();
    }

    private void setFilmTime() {
        if (!this.arr[7].isEmpty()) {
            try {
                if (this.arr[7].length() == 5) {
                    this.arr[7] = this.arr[7] + ":00";
                }
                LocalTime time = LocalTime.parse(this.arr[7], DateTimeFormatter.ofPattern("HH:mm:ss"));
                this.setFilmTime(time.toSecondOfDay());
            }
            catch (Exception ignore) {
                this.arr[7] = "";
                this.setFilmTime(-1);
            }
        } else {
            this.setFilmTime(-1);
        }
    }

    public void setLowerCase() {
        this.FILM_CHANNEL_STR = this.getChannel().toLowerCase();
        this.FILM_THEME_STR = this.getTheme().toLowerCase();
        this.FILM_TITLE_STR = this.getTitle().toLowerCase();
    }

    public void clearLowerCase() {
        this.FILM_CHANNEL_STR = "";
        this.FILM_THEME_STR = "";
        this.FILM_TITLE_STR = "";
    }

    public String getUrlForResolution(String resolution) {
        if (resolution.equals(RESOLUTION_SMALL)) {
            return this.getUrlNormalSmall();
        }
        if (resolution.equals(RESOLUTION_HD)) {
            return this.getUrlNormalHd();
        }
        return this.arr[14];
    }

    public String getIndex() {
        return (this.arr[1] + this.arr[2]).toLowerCase() + this.getUrlForHash();
    }

    public String getUrlForHash() {
        String url = "";
        if (this.arr[1].equals("ORF")) {
            String uurl = this.arr[14];
            try {
                String online = "/online/";
                url = uurl.substring(uurl.indexOf("/online/") + "/online/".length());
                if (!url.contains("/")) {
                    P2Log.errorLog(915230478, "Url: " + uurl);
                    return "";
                }
                if (!(url = url.substring(url.indexOf(47) + 1)).contains("/")) {
                    P2Log.errorLog(915230478, "Url: " + uurl);
                    return "";
                }
                if ((url = url.substring(url.indexOf(47) + 1)).isEmpty()) {
                    P2Log.errorLog(915230478, "Url: " + uurl);
                    return "";
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(915230478, ex, "Url: " + uurl);
            }
            return "ORF----" + url;
        }
        return this.arr[14];
    }

    private void preserveMemory() {
        if (this.arr[9].length() < 3) {
            this.arr[9] = this.arr[9].intern();
        }
        if (this.arr[18].length() < 15) {
            this.arr[18] = this.arr[18].intern();
        }
        this.arr[6] = this.arr[6].intern();
        this.arr[7] = this.arr[7].intern();
    }

    private String fillString(int anz, String s) {
        while (((String)s).length() < anz) {
            s = "0" + (String)s;
        }
        return s;
    }

    private void setFilmLength() {
        try {
            if (!this.arr[8].contains(":") && !this.arr[8].isEmpty()) {
                long durSecond = Long.parseLong(this.arr[8]);
                this.setDur(durSecond);
                if (durSecond > 0L) {
                    long hours = durSecond / 3600L;
                    long min = (durSecond -= hours * 3600L) / 60L;
                    long seconds = durSecond -= min * 60L;
                    this.arr[8] = this.fillString(2, String.valueOf(hours)) + ":" + this.fillString(2, String.valueOf(min)) + ":" + this.fillString(2, String.valueOf(seconds));
                } else {
                    this.arr[8] = "";
                }
            } else {
                long durSecond = 0L;
                if (!this.arr[8].isEmpty()) {
                    String[] parts = this.arr[8].split(":");
                    long power = 1L;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        durSecond += Long.parseLong(parts[i]) * power;
                        power *= 60L;
                    }
                }
                this.setDur(durSecond);
            }
        }
        catch (Exception ex) {
            this.setDur(0L);
            P2Log.errorLog(468912049, "Dauer: " + this.arr[8]);
        }
    }

    private void setDur(long durSecond) {
        if (durSecond <= 0L) {
            this.setDurationMinute(0);
            return;
        }
        int d = (int)(durSecond / 60L);
        if (d <= 0) {
            d = 1;
        }
        this.setDurationMinute(d);
    }

    private void setDatum() {
        this.filmDate.setTime(0L);
        if (!this.arr[6].isEmpty()) {
            try {
                if (this.arr[22].isEmpty()) {
                    this.filmDate = this.arr[7].isEmpty() ? new FilmDate(sdf_date.parse(this.arr[6]).getTime()) : new FilmDate(sdf_date_time.parse(this.arr[6] + this.arr[7]).getTime());
                    this.arr[22] = String.valueOf(this.filmDate.getTime() / 1000L);
                } else {
                    long l = Long.parseLong(this.arr[22]);
                    this.filmDate = new FilmDate(l * 1000L);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(915236701, ex, new String[]{"Datum: " + this.arr[6], "Zeit: " + this.arr[7]});
                this.filmDate = new FilmDate(0L);
                this.arr[6] = "";
                this.arr[7] = "";
            }
        }
    }

    private String getUrlNormalSmall() {
        if (!this.arr[18].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[18].substring(0, this.arr[18].indexOf(124)));
                return this.arr[14].substring(0, i) + this.arr[18].substring(this.arr[18].indexOf(124) + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.arr[14];
    }

    private String getUrlNormalHd() {
        if (!this.arr[19].isEmpty()) {
            try {
                int i = Integer.parseInt(this.arr[19].substring(0, this.arr[19].indexOf(124)));
                return this.arr[14].substring(0, i) + this.arr[19].substring(this.arr[19].indexOf(124) + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.arr[14];
    }

    public FilmData getCopy() {
        FilmData ret = new FilmData();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.filmDate = this.filmDate;
        ret.no = this.no;
        ret.filmSize = this.filmSize;
        ret.setDurationMinute(this.getDurationMinute());
        ret.setHd(this.isHd());
        ret.setSmall(this.isSmall());
        ret.setUt(this.isUt());
        return ret;
    }
}

