/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtdownload;

import de.p2tools.p2lib.mtdownload.TimedTextMarkupLanguageParser;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.P2UrlConnectionFactory;
import de.p2tools.p2lib.tools.net.PUrlTools;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class MTSubtitle {
    private static final int TIMEOUT = 10000;
    private static final String SUFFIX_TTML = "ttml";
    private static final String SUFFIX_SRT = "srt";
    private static final String SRT_FILETYPE = ".srt";
    private static final String SUFFIX_VTT = "vtt";

    private static String getSubtitleStr(String urlSubtitle, String fileNameWithoutSuffix) {
        String suffix = PUrlTools.getSuffixFromUrl(urlSubtitle);
        if (!suffix.endsWith(SUFFIX_SRT) && !suffix.endsWith(SUFFIX_VTT)) {
            suffix = SUFFIX_TTML;
        }
        return fileNameWithoutSuffix + "." + suffix;
    }

    public static Path getSubtitlePath(String urlSubtitle, String fileNameWithoutSuffix) {
        Path path;
        try {
            path = Paths.get(MTSubtitle.getSubtitleStr(urlSubtitle, fileNameWithoutSuffix), new String[0]);
        }
        catch (Exception ex) {
            path = null;
            P2Log.errorLog(951245412, "SubtitlePath");
        }
        return path;
    }

    public static Path getSrtPath(String fileNameWithoutSuffix) {
        return Paths.get(fileNameWithoutSuffix + SRT_FILETYPE, new String[0]);
    }

    private InputStream getContentDecoder(String encoding, InputStream in) throws IOException {
        if (encoding != null) {
            InflaterInputStream out = null;
            switch (encoding.toLowerCase()) {
                case "gzip": {
                    out = new GZIPInputStream(in);
                    break;
                }
                case "deflate": {
                    out = new InflaterInputStream(in, new Inflater(true));
                }
            }
            return out;
        }
        return in;
    }

    private void setupConnection(HttpURLConnection conn, String userAgent) {
        conn.setRequestProperty("User-Agent", userAgent);
        conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.setReadTimeout(10000);
        conn.setConnectTimeout(10000);
    }

    private void downloadContent(InputStream in, String strSubtitelFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(strSubtitelFile);){
            int n;
            byte[] buffer = new byte[65536];
            while ((n = in.read(buffer)) != -1) {
                fos.write(buffer, 0, n);
            }
            P2Log.sysLog(new String[]{"Untertitel", "  geschrieben"});
        }
    }

    private void writeSrt(String strSubtitelFile, String fileNameWithoutSuffix) {
        TimedTextMarkupLanguageParser ttmlp = new TimedTextMarkupLanguageParser();
        Path p = Paths.get(strSubtitelFile, new String[0]);
        if (ttmlp.parse(p) || ttmlp.parseXmlFlash(p)) {
            Path srt = MTSubtitle.getSrtPath(fileNameWithoutSuffix);
            ttmlp.toSrt(srt);
        }
        ttmlp.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSubtitle(String urlSubtitle, String fileNameWithoutSuffix, String destPath, String userAgent) {
        InputStream in = null;
        if (urlSubtitle.isEmpty()) {
            return;
        }
        try {
            P2Log.sysLog(new String[]{"Untertitel: ", urlSubtitle, "schreiben nach: ", destPath});
            Files.createDirectories(Paths.get(destPath, new String[0]), new FileAttribute[0]);
            HttpURLConnection conn = P2UrlConnectionFactory.getUrlConnection(urlSubtitle);
            this.setupConnection(conn, userAgent);
            if (conn.getResponseCode() < 400) {
                in = this.getContentDecoder(conn.getContentEncoding(), conn.getInputStream());
                String strSubtitelFile = MTSubtitle.getSubtitleStr(urlSubtitle, fileNameWithoutSuffix);
                this.downloadContent(in, strSubtitelFile);
                if (!strSubtitelFile.endsWith(SRT_FILETYPE) && !strSubtitelFile.endsWith(".vtt")) {
                    this.writeSrt(strSubtitelFile, fileNameWithoutSuffix);
                }
            } else {
                P2Log.errorLog(752301248, "url: " + urlSubtitle);
            }
        }
        catch (Exception ignored) {
            P2Log.errorLog(461203210, ignored, "SubtitelUrl: " + urlSubtitle);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

