/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtdownload;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.pnotification.P2Notification;
import de.p2tools.p2lib.mtdownload.DownloadFactory;
import de.p2tools.p2lib.mtdownload.DownloadProgressDialog_;
import de.p2tools.p2lib.tools.file.P2FileSize;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.P2UrlConnectionFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.stage.Stage;

public class HttpDownload_
extends Thread {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static int downloadRunning = 0;
    private final int DOWNLOAD_MAX_RESTART_HTTP = 4;
    private final Stage stage;
    private long downloaded = 0L;
    private String responseCode;
    private String exMessage;
    private String url;
    private String destDir;
    private String destName;
    private String destDirFile;
    private String userAgent = "";
    private long fileSize = 0L;
    private boolean error = false;
    private DownloadProgressDialog_ downloadProgressDialog = null;

    public HttpDownload_(Stage stage, String url, String destDir, String destName) {
        this.stage = stage;
        this.url = url;
        this.destDir = destDir;
        this.destName = destName;
        this.destDirFile = P2FileUtils.addsPath(destDir, destName);
        this.setName("DOWNLOAD FILE THREAD: " + destName);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public synchronized void run() {
        P2Log.sysLog("Download von: " + this.url + P2LibConst.LINE_SEPARATOR + "nach: " + this.destDirFile);
        ++downloadRunning;
        try {
            Files.createDirectories(Paths.get(this.destDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int restartCount = 0;
        boolean restart = true;
        HttpURLConnection conn = null;
        while (restart) {
            restart = false;
            if ((conn = this.startDownload(conn)) == null) {
                if (restartCount >= 4) continue;
                restart = true;
                continue;
            }
            try {
                InputStream inputStream2 = conn.getInputStream();
                try (FileOutputStream fileOutputStream = new FileOutputStream(new File(this.destDirFile), this.downloaded != 0L);){
                    this.downloadContent(inputStream2, fileOutputStream);
                }
                finally {
                    if (inputStream2 == null) continue;
                    inputStream2.close();
                }
            }
            catch (Exception ex) {
                if (ex instanceof IOException && restartCount < 4) {
                    if (ex instanceof SocketTimeoutException) {
                        ArrayList<CallSite> text = new ArrayList<CallSite>();
                        text.add((CallSite)((Object)("Timeout, Restarts: " + restartCount)));
                        text.add((CallSite)((Object)("Ziel: " + this.destDirFile)));
                        text.add((CallSite)((Object)("URL: " + this.url)));
                        P2Log.sysLog(text.toArray(new String[text.size()]));
                    }
                    ++restartCount;
                    restart = true;
                    continue;
                }
                this.exMessage = ex.getMessage();
                P2Log.errorLog(974512037, ex, "Fehler");
                this.error = true;
            }
        }
        this.closeConn(conn);
        this.deleteIfEmptyOrError(new File(this.destDirFile));
        if (this.error) {
            Platform.runLater(() -> P2Alert.showErrorAlert(this.stage, "Download fehlgeschlagen", "Download von: " + this.destDirFile + P2LibConst.LINE_SEPARATORx2 + "Der Download hat nicht geklappt." + (String)(this.exMessage != null ? P2LibConst.LINE_SEPARATORx2 + this.exMessage : "")));
        } else {
            P2Notification.addNotification("Download", "Der Download ist abgeschlossen" + P2LibConst.LINE_SEPARATOR + "und war erfolgreich.", P2Notification.STATE.SUCCESS);
        }
        --downloadRunning;
    }

    private HttpURLConnection startDownload(HttpURLConnection conn) {
        this.closeConn(conn);
        try {
            URL url = new URL(this.url);
            this.fileSize = DownloadFactory.getContentLength(url, false);
            conn = P2UrlConnectionFactory.getUrlConnection(url);
            int CONECTION_TIMEOUT_SECOND_DOWNLOAD = 250;
            conn.setConnectTimeout(1000 * CONECTION_TIMEOUT_SECOND_DOWNLOAD);
            conn.setReadTimeout(1000 * CONECTION_TIMEOUT_SECOND_DOWNLOAD);
            this.setupHttpConnection(conn);
            conn.connect();
            int httpResponseCode = conn.getResponseCode();
            if (httpResponseCode >= 400) {
                if (httpResponseCode == 416) {
                    conn.disconnect();
                    conn = P2UrlConnectionFactory.getUrlConnection(url);
                    this.downloaded = 0L;
                    this.setupHttpConnection(conn);
                    conn.connect();
                    if (conn.getResponseCode() >= 400) {
                        this.closeConn(conn);
                    }
                } else {
                    this.responseCode = "Responsecode: " + conn.getResponseCode() + P2LibConst.LINE_SEPARATOR + conn.getResponseMessage();
                    P2Log.errorLog(989895658, "HTTP-Fehler: " + conn.getResponseCode() + " " + conn.getResponseMessage());
                    this.closeConn(conn);
                }
            }
        }
        catch (IOException ex) {
            this.closeConn(conn);
            conn = null;
        }
        return conn;
    }

    private void downloadContent(InputStream inputStream2, FileOutputStream fileOutputStream) throws Exception {
        int len;
        byte[] buffer = new byte[4096];
        double pp = 0.0;
        long date1 = 0L;
        long date2 = 0L;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            this.downloadProgressDialog = new DownloadProgressDialog_(this.stage, this.destName, this.getText());
            countDownLatch.countDown();
        });
        countDownLatch.await();
        while ((len = inputStream2.read(buffer)) != -1) {
            date1 = new Date().getTime();
            if (this.downloadProgressDialog != null && this.downloadProgressDialog.isCanceled()) {
                this.error = true;
                break;
            }
            this.downloaded += (long)len;
            fileOutputStream.write(buffer, 0, len);
            if (this.downloaded <= 0L || date1 - date2 <= 500L || this.downloadProgressDialog == null) continue;
            date2 = new Date().getTime();
            double p = 1.0 * (double)this.downloaded / (double)this.fileSize;
            long l = (long)(p * 1000.0);
            if ((p = 1.0 * (double)l / 1000.0) == pp) continue;
            pp = p;
            this.downloadProgressDialog.setProgress(p, this.getText());
        }
        if (this.downloadProgressDialog != null) {
            this.downloadProgressDialog.close();
        }
        if (this.check()) {
            // empty if block
        }
    }

    private String getText() {
        return P2FileSize.convertToStr(this.downloaded) + " von " + P2FileSize.convertToStr(this.fileSize);
    }

    private void setupHttpConnection(HttpURLConnection conn) {
        conn.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
        if (!this.userAgent.isEmpty()) {
            conn.setRequestProperty("User-Agent", this.userAgent);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
    }

    private boolean check() {
        boolean ret = false;
        File file = new File(this.destDirFile);
        if (!file.exists()) {
            P2Log.errorLog(951203473, "Download fehlgeschlagen: Datei existiert nicht: " + this.destDirFile);
        } else {
            ret = true;
        }
        return ret;
    }

    private void closeConn(HttpURLConnection conn) {
        try {
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteIfEmptyOrError(File file) {
        try {
            if (file.exists() && (this.error || file.length() == 0L)) {
                this.error = true;
                P2Log.sysLog(new String[]{"Fehler oder leere Datei: l\u00f6schen", file.getAbsolutePath()});
                if (!file.delete()) {
                    throw new Exception();
                }
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(316704568, "Fehler beim l\u00f6schen" + file.getAbsolutePath());
        }
    }
}

