/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mtdownload;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.net.PUrlTools;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class DownloadDialogController_
extends P2DialogExtra {
    private final VBox vBoxCont;
    private final Button btnOk = new Button("_Ok");
    private final Button btnCancel = new Button("_Abbrechen");
    private final GridPane gridPane = new GridPane();
    private final TextField txtDestPath = new TextField();
    private final TextField txtName = new TextField();
    private final StringProperty filePath = new SimpleStringProperty();
    private final StringProperty fileName = new SimpleStringProperty();
    private final String url;
    private final String urlFile;
    private final String orgFileName;
    private final Stage stage;
    StringProperty path;
    private boolean nameChanged = false;
    private boolean ok = false;

    public DownloadDialogController_(Stage stage, String url, StringProperty path, String orgFileName) {
        super(stage, null, "Download", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.stage = stage;
        this.url = url;
        this.urlFile = PUrlTools.getFileName(url);
        this.orgFileName = orgFileName.isEmpty() ? this.urlFile : orgFileName;
        this.path = path;
        if (path == null || path.getValueSafe().isEmpty()) {
            this.filePath.set(P2InfoFactory.getHomePath());
        } else {
            this.filePath.set(path.getValue());
        }
        this.fileName.setValue(this.getFileName(this.filePath.getValueSafe(), this.orgFileName));
        this.vBoxCont = this.getVBoxCont();
        this.init(true);
    }

    @Override
    public void make() {
        this.vBoxCont.setPadding(new Insets(5.0));
        this.vBoxCont.setSpacing(10.0);
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.gridPane});
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
        this.gridPane.setMaxWidth(Double.MAX_VALUE);
        this.gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        Label lblDest = new Label("Speicherziel:");
        lblDest.setStyle("-fx-font-weight: bold;");
        Label lblSrc = new Label("Download:");
        lblSrc.setStyle("-fx-font-weight: bold;");
        Label lblDestPath = new Label("Pfad:");
        Label lblName = new Label("Dateiname:");
        Label lblUrlFile = new Label("Datei:");
        Label lblUrl = new Label("URL:");
        this.txtDestPath.textProperty().bindBidirectional(this.filePath);
        this.txtName.textProperty().bindBidirectional(this.fileName);
        this.txtName.textProperty().addListener((observableValue, s, t1) -> {
            this.nameChanged = true;
        });
        Button btnDest = new Button();
        btnDest.setGraphic(P2ProgIcons.IMAGE_FILE_OPEN.getImageView());
        btnDest.setTooltip(new Tooltip("Einen Ordner zum Speichern der Datei ausw\u00e4hlen"));
        btnDest.setOnAction(event -> {
            P2DirFileChooser.DirChooser(this.stage, this.txtDestPath);
            boolean nc = this.nameChanged;
            this.fileName.setValue(this.getFileName(this.filePath.getValueSafe(), this.fileName.getValueSafe()));
            this.nameChanged = nc;
        });
        int row = 0;
        this.gridPane.add(lblSrc, 0, row, 2, 1);
        this.gridPane.add(lblUrl, 0, ++row);
        this.gridPane.add(new Label(this.url), 1, row);
        this.gridPane.add(lblUrlFile, 0, ++row);
        this.gridPane.add(new Label(this.urlFile), 1, row);
        this.gridPane.add(new Label(" "), 0, ++row);
        this.gridPane.add(lblDest, 0, ++row, 2, 1);
        this.gridPane.add(lblDestPath, 0, ++row);
        this.gridPane.add(this.txtDestPath, 1, row);
        this.gridPane.add(btnDest, 2, row);
        this.gridPane.add(lblName, 0, ++row);
        this.gridPane.add(this.txtName, 1, row);
        this.btnOk.setOnAction(event -> {
            this.ok = this.checkDest();
            if (this.ok) {
                this.quit();
            }
        });
        this.btnCancel.setOnAction(event -> this.quit());
    }

    private void quit() {
        if (this.path != null) {
            this.path.setValue(this.txtDestPath.getText());
        }
        this.close();
    }

    private String getFileName(String dir, String name) {
        if (this.nameChanged) {
            return name;
        }
        Object newName = this.orgFileName;
        String file = P2FileUtils.addsPath(dir, this.orgFileName);
        String noSuff = P2FileUtils.removeFileNameSuffix(this.orgFileName);
        String suff = P2FileUtils.getFileNameSuffix(this.orgFileName);
        if (noSuff.isEmpty() || suff.isEmpty()) {
            return name;
        }
        int i = 1;
        while (P2FileUtils.fileExist(file)) {
            newName = noSuff + "-" + i++ + "." + suff;
            file = P2FileUtils.addsPath(dir, (String)newName);
        }
        return newName;
    }

    private boolean checkDest() {
        String destName;
        boolean ret = false;
        String destDir = this.txtDestPath.getText();
        String file = P2FileUtils.addsPath(destDir, destName = this.txtName.getText());
        if (P2FileUtils.fileExist(file)) {
            ret = false;
            P2Alert.BUTTON button = P2Alert.showAlert_yes_no("Hinweis", "Datei speichern", "Die Zieldatei exisiert bereits:" + P2LibConst.LINE_SEPARATORx2 + destName + P2LibConst.LINE_SEPARATORx2 + "Soll die Datei \u00fcberschrieben werden?");
            if (button.equals((Object)P2Alert.BUTTON.YES)) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public boolean getOk() {
        return this.ok;
    }

    public String getDestPath() {
        return this.txtDestPath.getText();
    }

    public String getDestName() {
        return this.txtName.getText();
    }
}

