/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.icons;

import de.p2tools.p2lib.P2LibConst;
import java.net.URL;
import javafx.scene.CacheHint;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.ColorInput;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;

public abstract class P2Icon {
    private final String path;
    private final String longPath;
    private final String fileName;
    private final String fileNameDark;
    private String url = "";
    private int w = 0;
    private int h = 0;

    public P2Icon(String longPath, String path, String fileName, int w, int h) {
        this.longPath = longPath;
        this.path = path;
        this.fileName = fileName;
        this.fileNameDark = "";
        this.w = w;
        this.h = h;
    }

    public P2Icon(String longPath, String path, String fileName, String fileNameDark, int w, int h) {
        this.longPath = longPath;
        this.path = path;
        this.fileName = fileName;
        this.fileNameDark = fileNameDark;
        this.w = w;
        this.h = h;
    }

    public String getPath() {
        return this.path;
    }

    public String getLongPath() {
        return this.longPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameDark() {
        return this.fileNameDark;
    }

    public String getPathFileName() {
        return this.path + this.fileName;
    }

    public String getPathFileNameDark() {
        return this.path + this.fileNameDark;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Image getImage() {
        if (this.url.isEmpty()) {
            return null;
        }
        return new Image(this.url, (double)this.w, (double)this.h, false, true);
    }

    public Image getImage(int w, int h) {
        this.setW(w);
        this.setH(h);
        if (this.url.isEmpty()) {
            return null;
        }
        return new Image(this.url, (double)w, (double)h, false, true);
    }

    public ImageView getImageView() {
        Image img = this.getImage();
        if (img == null) {
            return new ImageView();
        }
        ImageView imageView = new ImageView(img);
        imageView.setClip(new ImageView(img));
        if (P2LibConst.blackWhite.get()) {
            ColorAdjust monochrome = new ColorAdjust();
            monochrome.setSaturation(-1.0);
            Blend blush = new Blend(BlendMode.MULTIPLY, monochrome, new ColorInput(0.0, 0.0, imageView.getImage().getWidth(), imageView.getImage().getHeight(), Color.DARKGRAY));
            imageView.setEffect(blush);
            imageView.setCache(true);
            imageView.setCacheHint(CacheHint.SPEED);
        }
        return imageView;
    }

    public ImageView getImageView_() {
        Image img = this.getImage();
        if (img == null) {
            return new ImageView();
        }
        return new ImageView(img);
    }

    public ImageView getImageView(int w, int h) {
        this.setW(w);
        this.setH(h);
        Image img = this.getImage();
        if (img == null) {
            return new ImageView();
        }
        return new ImageView(img);
    }

    public String genUrl(Class<?> ... clazzAr) {
        String fileName = this.getFileNameDark().isEmpty() ? this.getFileName() : this.getFileNameDark();
        String p = this.getPath() + fileName;
        if (this.searchUrl(p, clazzAr)) {
            return this.getUrl();
        }
        p = this.getLongPath() + fileName;
        if (this.searchUrl(p, clazzAr)) {
            return this.getUrl();
        }
        p = "/" + this.getLongPath() + fileName;
        if (this.searchUrl(p, clazzAr)) {
            return this.getUrl();
        }
        return "";
    }

    public boolean searchUrl(String p, Class<?> ... clazzAr) {
        URL url;
        for (Class<?> clazz : clazzAr) {
            url = clazz.getResource(p);
            if (!this.set(url, p, "clazz.getResource: " + String.valueOf(clazz))) continue;
            return true;
        }
        url = this.getClass().getResource(p);
        if (this.set(url, p, "this.getClass().getResource")) {
            return true;
        }
        for (Class<?> clazz : clazzAr) {
            url = clazz.getClassLoader().getResource(p);
            if (!this.set(url, p, "clazz.getClassLoader().getResource: " + String.valueOf(clazz))) continue;
            return true;
        }
        url = ClassLoader.getSystemResource(p);
        if (this.set(url, p, "ClassLoader.getSystemResource")) {
            return true;
        }
        url = this.getClass().getClassLoader().getResource(p);
        return this.set(url, p, "this.getClass().getClassLoader().getResource");
    }

    public boolean set(URL url, String p, String caller) {
        if (url != null) {
            this.setUrl(url.toExternalForm());
            return true;
        }
        return false;
    }
}

