/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.hash;

import de.p2tools.p2lib.hash.HashException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileHash {
    public static String hashString(String text, String algorithm) throws HashException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = md.digest(text.getBytes("UTF-8"));
            return FileHash.convertToHexString(hashedBytes);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new HashException("Could not generate hash", ex);
        }
    }

    public static String hashFile(File file, String hAlgo) throws HashException {
        String string;
        FileInputStream inputStream2 = new FileInputStream(file);
        try {
            MessageDigest md = MessageDigest.getInstance(hAlgo);
            byte[] bytesBuffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream2.read(bytesBuffer)) != -1) {
                md.update(bytesBuffer, 0, bytesRead);
            }
            byte[] hashedBytes = md.digest();
            string = FileHash.convertToHexString(hashedBytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException ex) {
                throw new HashException("Could not generate hash", ex);
            }
        }
        inputStream2.close();
        return string;
    }

    private static String convertToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }
}

