/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.prange;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class P2TimePeriodBox
extends VBox {
    public static final int TIME_MAX_SEC = 86399;
    private final String pattern = "HH:mm";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
    private final int MIN_DIST = 15;
    private final int MIN_VALUE = 0;
    private final int MAX_VALUE = 96;
    private final int MIN_DIST_SEC = 900;
    private final IntegerProperty minValue = new SimpleIntegerProperty();
    private final IntegerProperty maxValue = new SimpleIntegerProperty();
    private final SplitMenuButton menuButton = new SplitMenuButton();
    private final Slider sliderMin = new Slider();
    private final Slider sliderMax = new Slider();
    private final Label lblMin = new Label("Von:");
    private final Label lblMax = new Label("Bis:");
    private final Label lblValueMin = new Label();
    private final Label lblValueMax = new Label();
    private String vluePrefix = "Dauer: ";

    public P2TimePeriodBox() {
        this.setPropValue(this.minValue, 0);
        this.setPropValue(this.maxValue, 96);
        this.minValue.setValue(0);
        this.maxValue.setValue(1440);
        this.init();
        this.initSlider();
    }

    public P2TimePeriodBox(IntegerProperty minValue, IntegerProperty maxValue) {
        this.minValue.bindBidirectional(minValue);
        this.maxValue.bindBidirectional(maxValue);
        this.init();
        this.initSlider();
    }

    public final void setTooltip(Tooltip value) {
        this.menuButton.setTooltip(value);
    }

    public int getMinValue() {
        return this.minValue.get();
    }

    public IntegerProperty minValueProperty() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue.set(minValue);
    }

    public int getMaxValue() {
        return this.maxValue.get();
    }

    public IntegerProperty maxValueProperty() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue.set(maxValue);
    }

    public String getVluePrefix() {
        return this.vluePrefix;
    }

    public void setVluePrefix(String vluePrefix) {
        this.vluePrefix = vluePrefix;
        this.setTimeTxt();
    }

    private void init() {
        this.setSpacing(5.0);
        this.setPadding(new Insets(0.0));
        HBox.setHgrow(this.menuButton, Priority.ALWAYS);
        this.menuButton.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().addAll((Node[])new Node[]{this.menuButton});
        this.menuButton.setOnMouseClicked(m -> {
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.resetSlider();
            }
        });
        this.menuButton.setOnMousePressed(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 1) {
                if (this.menuButton.isShowing()) {
                    this.menuButton.hide();
                } else {
                    this.menuButton.show();
                }
            }
        });
        this.sliderMin.setMinWidth(300.0);
        this.sliderMax.setMinWidth(300.0);
        GridPane gridPane1 = new GridPane();
        gridPane1.setHgap(10.0);
        gridPane1.setVgap(10.0);
        gridPane1.add(this.lblMin, 0, 0);
        gridPane1.add(this.sliderMin, 1, 0);
        gridPane1.add(this.lblValueMin, 2, 0);
        GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(10.0);
        gridPane2.setVgap(10.0);
        gridPane2.add(this.lblMax, 0, 0);
        gridPane2.add(this.sliderMax, 1, 0);
        gridPane2.add(this.lblValueMax, 2, 0);
        CustomMenuItem cmi1 = new CustomMenuItem(gridPane1);
        CustomMenuItem cmi2 = new CustomMenuItem(gridPane2);
        cmi1.setHideOnClick(false);
        cmi2.setHideOnClick(false);
        this.menuButton.getItems().addAll((MenuItem[])new MenuItem[]{cmi1, cmi2});
    }

    private void initSlider() {
        this.sliderMin.setMin(0.0);
        this.sliderMin.setMax(95.0);
        this.initSlider(this.sliderMin, this.minValue);
        this.sliderMin.setValue(this.minValue.getValue() / 900);
        this.minValue.addListener(l -> this.sliderMin.setValue(this.minValue.getValue() / 900));
        this.sliderMin.valueChangingProperty().addListener((observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.setPropValue(this.minValue, (int)this.sliderMin.getValue());
                this.repairMaxValue();
            }
        });
        this.sliderMax.setMin(1.0);
        this.sliderMax.setMax(96.0);
        this.initSlider(this.sliderMax, this.maxValue);
        this.sliderMax.setValue(this.maxValue.getValue() / 900);
        this.maxValue.addListener(l -> this.sliderMax.setValue(this.maxValue.getValue() / 900));
        this.sliderMax.valueChangingProperty().addListener((observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.setPropValue(this.maxValue, (int)this.sliderMax.getValue());
                this.repairMinValue();
            }
        });
        this.setTimeTxt();
    }

    private void resetSlider() {
        this.setPropValue(this.minValue, 0);
        this.setPropValue(this.maxValue, 96);
        this.setTimeTxt();
    }

    private void initSlider(Slider slider, IntegerProperty ip) {
        slider.setShowTickLabels(true);
        slider.setMinorTickCount(1);
        slider.setMajorTickUnit(16.0);
        slider.setBlockIncrement(1.0);
        slider.setSnapToTicks(false);
        slider.setShowTickLabels(true);
        slider.setLabelFormatter(new StringConverter<Double>(){

            @Override
            public String toString(Double x) {
                int i = x.intValue();
                i = i * 15 / 60;
                return "" + i;
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
        slider.valueProperty().addListener(l -> this.setTimeTxt());
    }

    private void repairMinValue() {
        int height;
        int low = (int)this.sliderMin.getValue();
        if (low >= (height = (int)this.sliderMax.getValue())) {
            low = height - 1;
            low = low < 0 ? 0 : low;
            this.sliderMin.setValue(low);
            this.setPropValue(this.minValue, low);
        }
    }

    private void repairMaxValue() {
        int low = (int)this.sliderMin.getValue();
        int height = (int)this.sliderMax.getValue();
        if (height <= low) {
            height = low + 1;
            height = height > 96 ? 96 : height;
            this.sliderMax.setValue(height);
            this.setPropValue(this.maxValue, height);
        }
    }

    private void setPropValue(IntegerProperty ip, int value) {
        ip.setValue(value * 900);
    }

    private void setTimeTxt() {
        String timeH;
        String STR_ALLES = "alles";
        int iLowSecond = (int)this.sliderMin.getValue() * 900;
        LocalTime lt = LocalTime.ofSecondOfDay(iLowSecond);
        String timeL = lt.format(this.formatter);
        int iHiSecond = (int)this.sliderMax.getValue() * 900;
        iHiSecond = iHiSecond > 86399 ? 86399 : iHiSecond;
        lt = LocalTime.ofSecondOfDay(iHiSecond);
        String string = timeH = iHiSecond == 86399 ? "24:00" : lt.format(this.formatter);
        if (iLowSecond == 0 && iHiSecond == 86399) {
            String text = this.vluePrefix + "alles";
            this.menuButton.setText(text);
        } else {
            String text = this.vluePrefix + "von " + timeL + " bis " + timeH + " Uhr";
            this.menuButton.setText(text);
        }
    }
}

