/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pnotification;

import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.pnotification.P2NotificationEvent;
import de.p2tools.p2lib.guitools.pnotification.P2NotificationFactory;
import de.p2tools.p2lib.tools.P2Exception;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.util.Duration;

public class P2Notify {
    public final String title;
    public final String message;
    public final Image image;
    public static Stage stage = null;
    public static Stage stageRef = null;
    public static final double ICON_WIDTH = 24.0;
    public static final double ICON_HEIGHT = 24.0;
    public static double width = 300.0;
    public static double offsetX = 15.0;
    public static double offsetY = 50.0;
    public static double spacingY = 10.0;
    public static Pos popupLocation = Pos.BOTTOM_RIGHT;
    public static Duration popupLifetime = Duration.millis(8000.0);
    public static Duration popupAnimationTime = Duration.millis(500.0);
    public static final ObservableList<Popup> popups = FXCollections.observableArrayList();
    public static Scene scene = null;
    private HBox hBoxBottom = null;
    private double height = 80.0;
    private final ObjectProperty<EventHandler<P2NotificationEvent>> onNotificationPressed = new ObjectPropertyBase<EventHandler<P2NotificationEvent>>(){

        @Override
        public Object getBean() {
            return this;
        }

        @Override
        public String getName() {
            return "onNotificationPressed";
        }
    };
    private final ObjectProperty<EventHandler<P2NotificationEvent>> onShowNotification = new ObjectPropertyBase<EventHandler<P2NotificationEvent>>(){

        @Override
        public Object getBean() {
            return this;
        }

        @Override
        public String getName() {
            return "onShowNotification";
        }
    };
    private final ObjectProperty<EventHandler<P2NotificationEvent>> onHideNotification = new ObjectPropertyBase<EventHandler<P2NotificationEvent>>(){

        @Override
        public Object getBean() {
            return this;
        }

        @Override
        public String getName() {
            return "onHideNotification";
        }
    };

    public P2Notify(String title, String message, Image image) {
        this.title = title;
        this.message = message;
        this.image = image;
        if (stage == null) {
            P2Exception.throwPException(912036478, "Notification: stage not set");
        }
        if (scene == null) {
            scene = stage.getScene();
        }
    }

    public P2Notify(String title, String message, Image image, HBox hBoxBottom) {
        this.title = title;
        this.message = message;
        this.image = image;
        this.hBoxBottom = hBoxBottom;
        if (stage == null) {
            P2Exception.throwPException(912036478, "Notification: stage not set");
        }
        if (scene == null) {
            scene = stage.getScene();
        }
    }

    public static void setStage(Stage stage) {
        P2Notify.stage = stage;
    }

    public void notify(P2Notify p2Notify) {
        this.showPopup(p2Notify);
        P2NotificationFactory.preOrder(popupLocation, spacingY);
    }

    private void showPopup(P2Notify p2Notify) {
        Popup popup = new Popup();
        Button btnClose = new Button();
        btnClose.getStyleClass().add("close-button");
        btnClose.setGraphic(P2ProgIcons.ICON_BUTTON_CLOSE.getImageView());
        btnClose.setOnAction(a -> this.closeNotification(popup, p2Notify));
        Label title = new Label(p2Notify.title);
        title.getStyleClass().add("title");
        ImageView icon = new ImageView(p2Notify.image);
        icon.setFitWidth(24.0);
        icon.setFitHeight(24.0);
        Label message = new Label(p2Notify.message, icon);
        message.getStyleClass().add("message");
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Node[])new Node[]{title, P2GuiTools.getHBoxGrower(), btnClose});
        VBox popupLayout = new VBox();
        popupLayout.setSpacing(10.0);
        popupLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        popupLayout.getChildren().addAll((Node[])new Node[]{hBox, message});
        if (this.hBoxBottom != null) {
            popupLayout.getChildren().add(this.hBoxBottom);
        }
        StackPane popupContent = new StackPane();
        popupContent.setPrefSize(width, this.height);
        popupContent.getStyleClass().add("p2Notify");
        popupContent.getChildren().addAll((Node[])new Node[]{popupLayout});
        popupContent.setPrefHeight(-1.0);
        popup.getContent().add(popupContent);
        popup.addEventHandler(MouseEvent.MOUSE_PRESSED, new WeakEventHandler<MouseEvent>(event -> this.fireNotificationEvent(new P2NotificationEvent(p2Notify, this, popup, P2NotificationEvent.NOTIFICATION_PRESSED))));
        popups.add(popup);
        KeyValue fadeOutBegin = new KeyValue(popup.opacityProperty(), 1.0);
        KeyValue fadeOutEnd = new KeyValue(popup.opacityProperty(), 0.0);
        KeyFrame kfBegin = new KeyFrame(Duration.ZERO, fadeOutBegin);
        KeyFrame kfEnd = new KeyFrame(popupAnimationTime, fadeOutEnd);
        Timeline timeline = new Timeline(kfBegin, kfEnd);
        timeline.setDelay(popupLifetime);
        timeline.setOnFinished(actionEvent -> Platform.runLater(() -> this.closeNotification(popup, p2Notify)));
        popup.show(stage);
        this.fireNotificationEvent(new P2NotificationEvent(p2Notify, this, popup, P2NotificationEvent.SHOW_NOTIFICATION));
        timeline.play();
    }

    void closeNotification(Popup POPUP, P2Notify NOTIFICATION) {
        POPUP.hide();
        popups.remove(POPUP);
        this.fireNotificationEvent(new P2NotificationEvent(NOTIFICATION, this, POPUP, P2NotificationEvent.HIDE_NOTIFICATION));
    }

    public static void setPopupLocation(Stage STAGE_REF, Pos POPUP_LOCATION) {
        if (null != STAGE_REF) {
            stageRef = STAGE_REF;
        }
        popupLocation = POPUP_LOCATION;
    }

    public static void setNotificationOwner(Stage OWNER) {
    }

    public static void setOffsetX(double OFFSET_X) {
        offsetX = OFFSET_X;
    }

    public static void setOffsetY(double OFFSET_Y) {
        offsetY = OFFSET_Y;
    }

    public static void setWidth(double WIDTH) {
        width = WIDTH;
    }

    public void setHeight(double HEIGHT) {
        this.height = HEIGHT;
    }

    public double getHeight() {
        return this.height;
    }

    public static void setSpacingY(double SPACING_Y) {
        spacingY = SPACING_Y;
    }

    public void stop() {
        popups.clear();
    }

    public Duration getPopupLifetime() {
        return popupLifetime;
    }

    public void setPopupLifetime(Duration POPUP_LIFETIME) {
        popupLifetime = Duration.millis(this.clamp(2000.0, 20000.0, POPUP_LIFETIME.toMillis()));
    }

    public Duration getPopupAnimationTime() {
        return popupAnimationTime;
    }

    public void setPopupAnimationTime(Duration POPUP_ANIMATION_TIME) {
        popupAnimationTime = Duration.millis(this.clamp(0.0, 1000.0, POPUP_ANIMATION_TIME.toMillis()));
    }

    public boolean isAlwaysOnTop() {
        return stage.isAlwaysOnTop();
    }

    public void setAlwaysOnTop(boolean ALWAYS_ON_TOP) {
        stage.setAlwaysOnTop(ALWAYS_ON_TOP);
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public final ObjectProperty<EventHandler<P2NotificationEvent>> onNotificationPressedProperty() {
        return this.onNotificationPressed;
    }

    public final EventHandler<P2NotificationEvent> getOnNotificationPressed() {
        return (EventHandler)this.onNotificationPressedProperty().get();
    }

    public final void setOnNotificationPressed(EventHandler<P2NotificationEvent> value) {
        this.onNotificationPressedProperty().set(value);
    }

    public final ObjectProperty<EventHandler<P2NotificationEvent>> onShowNotificationProperty() {
        return this.onShowNotification;
    }

    public final EventHandler<P2NotificationEvent> getOnShowNotification() {
        return (EventHandler)this.onShowNotificationProperty().get();
    }

    public final void setOnShowNotification(EventHandler<P2NotificationEvent> value) {
        this.onShowNotificationProperty().set(value);
    }

    public final ObjectProperty<EventHandler<P2NotificationEvent>> onHideNotificationProperty() {
        return this.onHideNotification;
    }

    public final EventHandler<P2NotificationEvent> getOnHideNotification() {
        return (EventHandler)this.onHideNotificationProperty().get();
    }

    public final void setOnHideNotification(EventHandler<P2NotificationEvent> value) {
        this.onHideNotificationProperty().set(value);
    }

    public void fireNotificationEvent(P2NotificationEvent EVENT) {
        EventType<? extends Event> TYPE = EVENT.getEventType();
        EventHandler<P2NotificationEvent> HANDLER = P2NotificationEvent.NOTIFICATION_PRESSED == TYPE ? this.getOnNotificationPressed() : (P2NotificationEvent.SHOW_NOTIFICATION == TYPE ? this.getOnShowNotification() : (P2NotificationEvent.HIDE_NOTIFICATION == TYPE ? this.getOnHideNotification() : null));
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle(EVENT);
    }
}

