/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pnotification;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.guitools.pnotification.P2Notify;
import de.p2tools.p2lib.tools.P2Exception;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class P2Notification {
    public static void addNotification(String title, String text, boolean error) {
        if (error) {
            P2Notification.addNotification(title, text, STATE.ERROR);
        } else {
            P2Notification.addNotification(title, text, STATE.INFO);
        }
    }

    public static void addNotification(String title, String text, STATE state) {
        Platform.runLater(() -> {
            Image image = switch (state) {
                case STATE.INFO -> P2ProgIcons.INFO_ICON.getImage();
                case STATE.WARNING -> P2ProgIcons.WARNING_ICON.getImage();
                case STATE.SUCCESS -> P2ProgIcons.SUCCESS_ICON.getImage();
                default -> P2ProgIcons.ERROR_ICON.getImage();
            };
            P2Notify notification = new P2Notify(title, text, image);
            notification.notify(notification);
        });
    }

    public static void addNotification(String title, String text, STATE state, HBox hBoxBottom) {
        Platform.runLater(() -> {
            Image image = switch (state) {
                case STATE.INFO -> P2ProgIcons.INFO_ICON.getImage();
                case STATE.WARNING -> P2ProgIcons.WARNING_ICON.getImage();
                case STATE.SUCCESS -> P2ProgIcons.SUCCESS_ICON.getImage();
                default -> P2ProgIcons.ERROR_ICON.getImage();
            };
            P2Notify notification = new P2Notify(title, text, image, hBoxBottom);
            notification.notify(notification);
        });
    }

    static {
        Platform.runLater(() -> {
            Stage stage = P2LibConst.primaryStage;
            if (stage == null) {
                P2Exception.throwPException(912036447, "PNotification: stage not set");
            }
            P2Notify.stage = stage;
        });
    }

    public static enum STATE {
        INFO,
        WARNING,
        SUCCESS,
        ERROR;

    }
}

