/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pclosepane;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class P2ClosePaneDialog
extends P2DialogExtra {
    private final Pane pane;
    private final BooleanProperty dialogIsRip;
    private final BooleanProperty tabIsShowing;
    private final ChangeListener<? super Boolean> tabListener = (observable2, oldValue, newValue) -> this.setVis();

    public P2ClosePaneDialog(Pane pane, String title, StringProperty sizeProperty, BooleanProperty dialogIsRip, BooleanProperty tabIsShowing, BooleanProperty maskerVisible) {
        super(P2LibConst.primaryStage, sizeProperty, title, false, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.pane = pane;
        this.dialogIsRip = dialogIsRip;
        this.tabIsShowing = tabIsShowing;
        if (maskerVisible != null) {
            this.getMaskerPane().visibleProperty().bind(maskerVisible);
        }
        this.init(this.tabIsShowing.get());
        this.tabIsShowing.addListener(this.tabListener);
        this.setVis();
    }

    public P2ClosePaneDialog(Pane pane, String title, StringProperty sizeProperty, BooleanProperty dialogIsRip) {
        super(P2LibConst.primaryStage, sizeProperty, title, false, false, P2DialogExtra.DECO.NO_BORDER);
        this.pane = pane;
        this.dialogIsRip = dialogIsRip;
        this.tabIsShowing = new SimpleBooleanProperty(true);
        this.init(this.tabIsShowing.get());
        this.tabIsShowing.addListener(this.tabListener);
        this.setVis();
    }

    @Override
    public void make() {
        VBox.setVgrow(this.pane, Priority.ALWAYS);
        this.getVBoxCont().setPadding(new Insets(0.0));
        this.getVBoxCont().getChildren().add(this.pane);
    }

    @Override
    public void close() {
        super.close();
        this.tabIsShowing.removeListener(this.tabListener);
        this.dialogIsRip.set(false);
    }

    private void setVis() {
        if (this.tabIsShowing.get()) {
            this.showDialog();
        } else {
            this.getStage().hide();
        }
    }
}

