/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.guitools.P2Styles;
import de.p2tools.p2lib.tools.P2RegEx;
import java.util.regex.Pattern;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TextField;

public class P2TextFieldRegEx
extends TextField {
    StringProperty stringProperty = null;
    private boolean stateLabel = false;
    private ChangeListener changeListener;
    private Pattern pattern = null;

    public P2TextFieldRegEx() {
        this.init();
    }

    public P2TextFieldRegEx(boolean stateLabel) {
        this.stateLabel = stateLabel;
        this.setStateLabel();
        this.init();
    }

    public P2TextFieldRegEx(StringProperty property) {
        this.stringProperty = property;
        this.init();
    }

    public P2TextFieldRegEx(StringProperty property, boolean stateLabel) {
        this.stringProperty = property;
        this.stateLabel = stateLabel;
        this.setStateLabel();
        this.init();
    }

    public P2TextFieldRegEx(String regEx) {
        this.pattern = P2RegEx.makePattern(regEx);
        this.init();
    }

    public P2TextFieldRegEx(String regEx, boolean stateLabel) {
        this.pattern = P2RegEx.makePattern(regEx);
        this.stateLabel = stateLabel;
        this.setStateLabel();
        this.init();
    }

    public void setStateLabel(boolean stateLabel) {
        this.stateLabel = stateLabel;
        this.setStateLabel();
    }

    private void setStateLabel() {
        this.setEditable(!this.stateLabel);
        if (this.stateLabel) {
            this.setStyle(P2Styles.PTEXTFIELD_LABEL);
        }
    }

    public StringProperty getStringProperty() {
        return this.stringProperty;
    }

    public void setStringProperty(StringProperty property) {
        this.unBind();
        this.stringProperty = property;
        this.bindBidirectional();
    }

    public void setRegEx(String regEx) {
        this.pattern = P2RegEx.makePattern(regEx);
    }

    public void bindBidirectional(StringProperty property) {
        this.stringProperty = property;
        this.bindBidirectional();
    }

    public void bindBidirectional() {
        if (this.stringProperty == null) {
            return;
        }
        this.stringProperty.addListener(this.changeListener);
        this.textProperty().bindBidirectional(this.stringProperty);
        this.check();
    }

    public void unBind() {
        if (this.stringProperty == null) {
            return;
        }
        this.stringProperty.removeListener(this.changeListener);
        this.textProperty().unbindBidirectional(this.stringProperty);
    }

    private void init() {
        this.bindBidirectional();
        this.changeListener = (observable2, oldValue, newValue) -> this.check();
    }

    private void check() {
        if (P2RegEx.check(this.stringProperty.getValue(), this.pattern)) {
            this.setStyle(this.stateLabel ? P2Styles.PTEXTFIELD_LABEL : "");
        } else {
            this.setStyle(this.stateLabel ? P2Styles.PTEXTFIELD_LABEL_ERROR : P2Styles.PTEXTFIELD_ERROR);
        }
    }
}

