/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class P2SmallGuiFactory {
    private static final int MOVE_SIZE = 20;
    private static double xOffset = 0.0;
    private static double yOffset = 0.0;
    private static double xSize = 0.0;
    private static double ySize = 0.0;
    private static double xPos = 0.0;
    private static double yPos = 0.0;

    private P2SmallGuiFactory() {
    }

    public static void addBorderListener(Stage stage) {
        stage.getScene().setOnMousePressed(event -> {
            xOffset = event.getSceneX();
            yOffset = event.getSceneY();
            xSize = stage.getWidth();
            ySize = stage.getHeight();
            xPos = event.getScreenX();
            yPos = event.getScreenY();
            if (P2SmallGuiFactory.isUp() && P2SmallGuiFactory.isLeft()) {
                stage.getScene().setCursor(Cursor.NW_RESIZE);
            } else if (P2SmallGuiFactory.isUp() && P2SmallGuiFactory.isRight()) {
                stage.getScene().setCursor(Cursor.NE_RESIZE);
            } else if (P2SmallGuiFactory.isDown() && P2SmallGuiFactory.isRight()) {
                stage.getScene().setCursor(Cursor.SE_RESIZE);
            } else if (P2SmallGuiFactory.isDown() && P2SmallGuiFactory.isLeft()) {
                stage.getScene().setCursor(Cursor.SW_RESIZE);
            } else {
                stage.getScene().setCursor(Cursor.OPEN_HAND);
            }
        });
        stage.getScene().setOnMouseReleased(event -> stage.getScene().setCursor(Cursor.DEFAULT));
        stage.getScene().setOnMouseDragged(event -> {
            if (P2SmallGuiFactory.isUp() && P2SmallGuiFactory.isLeft()) {
                P2SmallGuiFactory.moveUp(stage, event);
                P2SmallGuiFactory.moveLeft(stage, event);
            } else if (P2SmallGuiFactory.isUp() && P2SmallGuiFactory.isRight()) {
                P2SmallGuiFactory.moveUp(stage, event);
                P2SmallGuiFactory.moveRight(stage, event);
            } else if (P2SmallGuiFactory.isDown() && P2SmallGuiFactory.isLeft()) {
                P2SmallGuiFactory.moveDown(stage, event);
                P2SmallGuiFactory.moveLeft(stage, event);
            } else if (P2SmallGuiFactory.isDown() && P2SmallGuiFactory.isRight()) {
                P2SmallGuiFactory.moveDown(stage, event);
                P2SmallGuiFactory.moveRight(stage, event);
            } else {
                stage.setX(event.getScreenX() - xOffset);
                stage.setY(event.getScreenY() - yOffset);
            }
        });
        stage.initStyle(StageStyle.TRANSPARENT);
    }

    private static boolean isUp() {
        return yOffset < 20.0;
    }

    private static boolean isDown() {
        return yOffset > ySize - 20.0;
    }

    private static boolean isLeft() {
        return xOffset < 20.0;
    }

    private static boolean isRight() {
        return xOffset > xSize - 20.0;
    }

    private static void moveRight(Stage stage, MouseEvent event) {
        double newX = xSize + event.getScreenX() - xPos;
        stage.setWidth(newX);
    }

    private static void moveLeft(Stage stage, MouseEvent event) {
        double newX = xSize + xPos - event.getScreenX();
        double moveX = xPos - event.getScreenX();
        stage.setWidth(newX);
        stage.setX(xPos - moveX);
    }

    private static void moveUp(Stage stage, MouseEvent event) {
        double newY = ySize + yPos - event.getScreenY();
        double moveY = yPos - event.getScreenY();
        stage.setHeight(newY);
        stage.setY(yPos - moveY);
    }

    private static void moveDown(Stage stage, MouseEvent event) {
        double newY = ySize + event.getScreenY() - yPos;
        stage.setHeight(newY);
    }
}

