/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public class P2SeparatorComboBox<T>
extends ComboBox<T> {
    public static final String SEPARATOR = "=====<>=====";
    public static final String SEPARATOR_OLD = "-----======-----";

    public P2SeparatorComboBox() {
        this.setup();
    }

    public static boolean isSeparator(String str) {
        return str.equals(SEPARATOR) || str.equals(SEPARATOR_OLD);
    }

    private void setup() {
        SingleSelectionModel model = new SingleSelectionModel<T>(){

            @Override
            public void select(T item) {
                if (P2SeparatorComboBox.isSeparator(item.toString())) {
                    return;
                }
                super.select(item);
            }

            @Override
            public void select(int index) {
                int itemCount = this.getItemCount();
                if (itemCount == 0 || index < 0 || index >= itemCount) {
                    return;
                }
                Object item = P2SeparatorComboBox.this.getItems().get(index);
                if (P2SeparatorComboBox.isSeparator(item.toString())) {
                    return;
                }
                super.select(index);
            }

            @Override
            protected int getItemCount() {
                return P2SeparatorComboBox.this.getItems().size();
            }

            @Override
            protected T getModelItem(int index) {
                if (index < 0 || P2SeparatorComboBox.this.getItems().isEmpty()) {
                    return null;
                }
                return P2SeparatorComboBox.this.getItems().get(index);
            }
        };
        Callback callback = new Callback<ListView<T>, ListCell<T>>(){

            @Override
            public ListCell<T> call(ListView<T> param) {
                ListCell cell = new ListCell<T>(){

                    @Override
                    public void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        if (item != null) {
                            this.setText(item.toString());
                            if (P2SeparatorComboBox.isSeparator(item.toString())) {
                                this.setTextFill(Color.LIGHTGRAY);
                                this.setDisable(true);
                            } else {
                                this.setTextFill(Color.BLACK);
                                this.setDisable(false);
                            }
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.setSelectionModel(model);
        this.setCellFactory(callback);
    }
}

