/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Optional;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.stage.Stage;

public class P2Hyperlink
extends Hyperlink {
    private String url;
    private final StringProperty prog;
    private final Stage stage;
    private boolean changeAble = false;

    public P2Hyperlink(Stage stage, String url, StringProperty prog) {
        super(url);
        this.stage = stage;
        this.url = url;
        this.prog = prog;
        this.init();
    }

    public P2Hyperlink(String url, StringProperty prog) {
        super(url);
        this.stage = P2LibConst.primaryStage;
        this.url = url;
        this.prog = prog;
        this.init();
    }

    public P2Hyperlink(String url) {
        super(url);
        this.stage = P2LibConst.primaryStage;
        this.url = url;
        this.prog = null;
        this.init();
    }

    public void setUrl(String url) {
        this.url = url;
        super.setText(url);
    }

    public void setChangeable() {
        this.changeAble = true;
    }

    private void init() {
        this.setPadding(new Insets(0.0));
        this.setStyle("-fx-font-size: 1.1em;");
        this.setOnAction(a -> {
            try {
                P2Open.openURL(this.stage, this.url, this.prog);
            }
            catch (Exception e) {
                P2Log.errorLog(974125469, e);
            }
        });
        this.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.setContextMenu(this.getMenu());
            }
        });
    }

    private ContextMenu getMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copyUrl = new MenuItem("URL kopieren");
        copyUrl.setOnAction(a -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(this.url);
            clipboard.setContent(content);
        });
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{copyUrl});
        if (this.changeAble) {
            MenuItem changeUrl = new MenuItem("URL \u00e4ndern");
            changeUrl.setOnAction(a -> {
                TextInputDialog dialog = new TextInputDialog(this.url);
                dialog.setResizable(true);
                dialog.setTitle("URL \u00e4ndern");
                dialog.setHeaderText("Eine neue URL angeben");
                dialog.setContentText("URL:");
                dialog.initOwner(this.stage);
                Optional result = dialog.showAndWait();
                result.ifPresent(newUrl -> {
                    this.url = newUrl;
                    this.setText(this.url);
                });
            });
            contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{changeUrl});
        }
        return contextMenu;
    }
}

