/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.stage.Stage;

public class P2GuiSize {
    public static void getSize(StringProperty property, Stage stage) {
        if (stage != null && stage.getScene() != null && property != null) {
            property.set((int)stage.getWidth() + ":" + (int)stage.getHeight() + ":" + (int)stage.getX() + ":" + (int)stage.getY() + ":" + (int)stage.getScene().getWidth() + ":" + (int)stage.getScene().getHeight() + ":" + (int)stage.getScene().getX() + ":" + (int)stage.getScene().getY());
        }
    }

    public static int getStageSize(StringProperty property, boolean width) {
        int value = 0;
        String[] arr = property.getValue().split(":");
        try {
            if (arr.length >= 2) {
                value = width ? Integer.parseInt(arr[0]) : Integer.parseInt(arr[1]);
            }
        }
        catch (Exception ex) {
            value = 0;
        }
        return value;
    }

    public static int getStagePos(StringProperty property, boolean posX) {
        int value = 0;
        String[] arr = property.getValue().split(":");
        try {
            if (arr.length >= 4) {
                value = posX ? Integer.parseInt(arr[2]) : Integer.parseInt(arr[3]);
            }
        }
        catch (Exception ex) {
            value = 0;
        }
        return value;
    }

    public static int getSceneSize(StringProperty property, boolean width) {
        int value = 0;
        String[] arr = property.getValue().split(":");
        try {
            value = arr.length >= 6 ? (width ? Integer.parseInt(arr[4]) : Integer.parseInt(arr[5])) : P2GuiSize.getStageSize(property, width);
        }
        catch (Exception ex) {
            value = 0;
        }
        return value;
    }

    public static int getScenePos(StringProperty property, boolean posX) {
        int value = 0;
        String[] arr = property.getValue().split(":");
        try {
            if (arr.length >= 8) {
                value = posX ? Integer.parseInt(arr[6]) : Integer.parseInt(arr[7]);
            }
        }
        catch (Exception ex) {
            value = 0;
        }
        return value;
    }

    public static void setSizePos(StringProperty sizeConfiguration, Stage stage, Stage ownerForCenteringDialog) {
        SimpleStringProperty s = sizeConfiguration == null ? null : new SimpleStringProperty(sizeConfiguration.getValueSafe());
        P2GuiSize.setSize(s, stage);
        P2GuiSize.setPos(s, stage, ownerForCenteringDialog);
    }

    public static void setSizePos(StringProperty sizeConfiguration, Stage stage) {
        SimpleStringProperty s = new SimpleStringProperty(sizeConfiguration.getValueSafe());
        P2GuiSize.setSize(s, stage);
        P2GuiSize.setPos(s, stage, null);
    }

    public static void setPos(StringProperty sizeConfiguration, Stage newStage) {
        P2GuiSize.setPos(sizeConfiguration, newStage, null);
    }

    public static void setSize(StringProperty sizeConfiguration, Stage newStage) {
        int h = 0;
        int w = 0;
        boolean size = false;
        String[] arr = new String[]{""};
        if (sizeConfiguration != null && !sizeConfiguration.getValueSafe().isEmpty()) {
            arr = sizeConfiguration.getValue().split(":");
        }
        if (arr.length >= 2) {
            size = true;
            w = P2GuiSize.getStageSize(sizeConfiguration, true);
            h = P2GuiSize.getStageSize(sizeConfiguration, false);
        }
        if (size) {
            if (w <= 25 || h <= 25) {
                newStage.sizeToScene();
            } else {
                newStage.setWidth(w);
                newStage.setHeight(h);
            }
        } else {
            newStage.sizeToScene();
        }
    }

    public static void setMinSize(StringProperty sizeConfiguration, Stage newStage) {
        String[] arr = new String[]{""};
        if (sizeConfiguration != null && !sizeConfiguration.getValueSafe().isEmpty()) {
            arr = sizeConfiguration.getValueSafe().split(":");
        }
        if (arr.length >= 2) {
            int w = P2GuiSize.getStageSize(sizeConfiguration, true);
            int h = P2GuiSize.getStageSize(sizeConfiguration, false);
            newStage.setMinWidth(w);
            newStage.setMinHeight(h);
        }
    }

    public static void resetMinSize(Stage stage) {
        stage.setMinWidth(0.0);
        stage.setMinHeight(0.0);
    }

    public static void setPos(StringProperty sizeConfiguration, Stage newStage, Stage ownerForCenteringDialog) {
        int posX = 0;
        int posY = 0;
        boolean pos = false;
        String[] arr = new String[]{""};
        if (sizeConfiguration != null && !sizeConfiguration.getValueSafe().isEmpty()) {
            arr = sizeConfiguration.getValueSafe().split(":");
        }
        if (arr.length >= 4) {
            pos = true;
            posX = P2GuiSize.getStagePos(sizeConfiguration, true);
            posY = P2GuiSize.getStagePos(sizeConfiguration, false);
        }
        if (pos) {
            if (posX < 0) {
                posX = 0;
            }
            if (posY < 0) {
                posY = 0;
            }
            newStage.setX(posX);
            newStage.setY(posY);
        } else {
            P2GuiSize.setInFrontOfPrimaryStage(newStage, ownerForCenteringDialog);
        }
    }

    private static void setInFrontOfPrimaryStage(Stage newStage, Stage ownerForCenteringDialog) {
        if (ownerForCenteringDialog == null) {
            newStage.centerOnScreen();
            return;
        }
        P2GuiSize.setStage(newStage, ownerForCenteringDialog);
    }

    private static void setStage(Stage newStage, Stage owner) {
        double y;
        double x;
        double nX = newStage.getWidth();
        double ny = newStage.getHeight();
        if (nX >= 0.0 || ny >= 0.0) {
            x = owner.getX() + owner.getWidth() / 2.0 - newStage.getWidth() / 2.0;
            y = owner.getY() + owner.getHeight() / 2.0 - newStage.getHeight() / 2.0;
        } else {
            x = owner.getX() + owner.getWidth() / 2.0;
            y = owner.getY() + owner.getHeight() / 2.0;
        }
        newStage.setX(x);
        newStage.setY(y);
    }
}

