/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.guitools.P2Styles;
import de.p2tools.p2lib.tools.GermanStringSorter;
import de.p2tools.p2lib.tools.P2RegEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;

public class P2ComboBoxString
extends ComboBox<String> {
    public final int MAX_ELEMENTS = 15;
    private int maxElements = 15;
    private StringProperty selValueStringProperty = null;
    private ObservableList<String> itemsList = null;
    Pattern pattern = null;

    public P2ComboBoxString() {
        this.setEditable(true);
    }

    public P2ComboBoxString(String regEx) {
        this.setEditable(true);
        this.pattern = P2RegEx.makePattern(regEx);
    }

    public void init(ObservableList<String> dataList) {
        this.itemsList = dataList;
        this.setCombo("");
    }

    public void init(ObservableList<String> dataList, StringProperty selValueStringProperty) {
        this.itemsList = dataList;
        this.selValueStringProperty = selValueStringProperty;
        this.setCombo(selValueStringProperty.getValueSafe());
    }

    public void init(ObservableList<String> dataList, String init, StringProperty selValueStringProperty) {
        this.selValueStringProperty = selValueStringProperty;
        this.itemsList = dataList;
        this.setCombo(init);
    }

    public void setRegEx(String regEx) {
        this.pattern = P2RegEx.makePattern(regEx);
    }

    public void bindSelValueProperty(StringProperty stringProperty) {
        this.unbind();
        this.selValueStringProperty = stringProperty;
        this.bind();
    }

    public void unbindSelValueProperty() {
        this.unbind();
        this.selValueStringProperty = null;
        this.selectElement("");
    }

    public String getSelValue() {
        String s = (String)this.getSelectionModel().getSelectedItem();
        if (s == null) {
            s = "";
        }
        return s;
    }

    public ReadOnlyObjectProperty<String> getSelValueProperty() {
        ReadOnlyObjectProperty<String> s = this.getSelectionModel().selectedItemProperty();
        return s;
    }

    public void selectElement(String element) {
        this.setValue(element);
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public void setMaxElements(int maxElements) {
        this.maxElements = maxElements;
    }

    private void setCombo(String start) {
        if (this.itemsList == null) {
            return;
        }
        if (!start.isEmpty() && !this.itemsList.contains(start)) {
            this.itemsList.add(start);
        }
        this.reduceList();
        Collections.sort(this.itemsList, new GermanStringSorter());
        this.setItems(this.itemsList);
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue != null && !this.itemsList.contains(newValue)) {
                this.itemsList.add(1, (String)newValue);
                this.setValue(newValue);
            }
        });
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> this.check());
        this.getEditor().setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.getEditor().setContextMenu(this.getMenu());
            }
        });
        this.itemsList.addListener(c -> {
            if (this.itemsList.size() == 1) {
                this.getSelectionModel().selectFirst();
            }
        });
        this.bind();
        if (!start.isEmpty() && this.getSelValue().isEmpty()) {
            this.selectElement(start);
        }
    }

    private void bind() {
        if (this.selValueStringProperty == null) {
            return;
        }
        this.valueProperty().bindBidirectional(this.selValueStringProperty);
    }

    private void unbind() {
        if (this.selValueStringProperty == null) {
            this.setValue("");
            return;
        }
        this.valueProperty().unbindBidirectional(this.selValueStringProperty);
    }

    private void delList() {
        String akt = this.getSelValue();
        int select = 0;
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        if (!akt.isEmpty()) {
            list.add(akt);
            select = 1;
        }
        this.itemsList.setAll((Collection<String>)list);
        this.getSelectionModel().select(select);
    }

    private void delAll() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        this.itemsList.setAll((Collection<String>)list);
        this.getSelectionModel().selectFirst();
    }

    private void reduceList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.itemsList.isEmpty() || this.itemsList.get(0) != "") {
            this.itemsList.add(0, "");
        }
        ListIterator it = this.itemsList.listIterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (!list.contains(s)) {
                list.add(s);
                continue;
            }
            it.remove();
        }
    }

    private ContextMenu getMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem delEntries = new MenuItem("andere Eintr\u00e4ge l\u00f6schen");
        delEntries.setOnAction(a -> this.delList());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{delEntries});
        MenuItem delAll = new MenuItem("alles l\u00f6schen");
        delAll.setOnAction(a -> this.delAll());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{delAll});
        return contextMenu;
    }

    private void check() {
        if (this.pattern == null) {
            return;
        }
        if (P2RegEx.check(this.getEditor().textProperty().getValue(), this.pattern)) {
            this.getEditor().setStyle("");
        } else {
            this.getEditor().setStyle(P2Styles.PCOMBO_ERROR);
        }
    }
}

