/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs.dialog;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.dialogs.dialog.P2Dialog;
import de.p2tools.p2lib.guitools.P2WindowIcon;
import de.p2tools.p2lib.guitools.pmask.P2MaskerPaneMin;
import de.p2tools.p2lib.icons.P2Image;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class P2DialogExtra
extends P2Dialog {
    private final VBox vBoxCompleteDialog = new VBox(5.0);
    private final HBox hBoxOverAll = new HBox(10.0);
    private final HBox hBoxTitle = new HBox(10.0);
    private final VBox vBoxCont = new VBox(10.0);
    private final HBox hBoxOverButtons = new HBox(10.0);
    private final HBox hBoxLeft = new HBox(10.0);
    private final HBox hBoxRight = new HBox(10.0);
    private final ButtonBar buttonBar = new ButtonBar();
    private final ScrollPane scrollPane = new ScrollPane();
    private P2MaskerPaneMin maskerPane = null;
    private boolean masker = false;
    private DECO deco = DECO.BORDER;

    public P2DialogExtra() {
        super(P2LibConst.actStage, null, "", true, true);
        this.initDialog();
    }

    public P2DialogExtra(StringProperty conf, String title) {
        super(P2LibConst.actStage, conf, title, true, true);
        this.initDialog();
    }

    public P2DialogExtra(Stage ownerForCenteringDialog, StringProperty conf, String title) {
        super(ownerForCenteringDialog, conf, title, true, true);
        this.initDialog();
    }

    public P2DialogExtra(Stage ownerForCenteringDialog, StringProperty conf, String title, boolean modal, boolean setOnlySize) {
        super(ownerForCenteringDialog, conf, title, modal, setOnlySize);
        this.initDialog();
    }

    public P2DialogExtra(Stage ownerForCenteringDialog, StringProperty conf, String title, boolean modal, boolean setOnlySize, DECO deco) {
        super(ownerForCenteringDialog, conf, title, modal, setOnlySize);
        this.deco = deco;
        this.initDialog();
    }

    public P2DialogExtra(Stage ownerForCenteringDialog, StringProperty conf, String title, boolean modal, boolean setOnlySize, DECO deco, boolean masker) {
        super(ownerForCenteringDialog, conf, title, modal, setOnlySize);
        this.deco = deco;
        this.masker = masker;
        this.maskerPane = new P2MaskerPaneMin();
        this.initDialog();
    }

    public static ArrayList<P2Dialog> getDialogList() {
        return dialogList;
    }

    public static void hideAllDialog() {
        dialogList.forEach(p2Dialog -> Platform.runLater(p2Dialog::hide));
    }

    public static void closeAllDialog() {
        dialogList.forEach(p2Dialog -> Platform.runLater(p2Dialog::close));
    }

    public static void showAllDialog() {
        dialogList.forEach(p2Dialog -> Platform.runLater(p2Dialog::showDialog));
    }

    public static void saveAllDialog() {
        dialogList.forEach(P2Dialog::saveDialog);
    }

    public static void setIconForAllDialog() {
        dialogList.forEach(p2Dialog -> P2WindowIcon.addWindowIcon(p2Dialog.getStage()));
    }

    public VBox getVBoxCompleteDialog() {
        return this.vBoxCompleteDialog;
    }

    public HBox getHBoxOverAll() {
        this.hBoxOverAll.setVisible(true);
        this.hBoxOverAll.setManaged(true);
        return this.hBoxOverAll;
    }

    public HBox getHBoxTitle() {
        this.hBoxTitle.setVisible(true);
        this.hBoxTitle.setManaged(true);
        return this.hBoxTitle;
    }

    public VBox getVBoxCont() {
        return this.vBoxCont;
    }

    public HBox getHBoxOverButtons() {
        return this.hBoxOverButtons;
    }

    public HBox getHboxLeft() {
        return this.hBoxLeft;
    }

    public HBox getHboxRight() {
        return this.hBoxRight;
    }

    public ButtonBar getButtonBar() {
        return this.buttonBar;
    }

    public void addOkButton(Button btnOk) {
        if (btnOk != null) {
            ButtonBar.setButtonData(btnOk, ButtonBar.ButtonData.OK_DONE);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnOk});
        }
    }

    public void addCancelButton(Button btnCancel) {
        if (btnCancel != null) {
            ButtonBar.setButtonData(btnCancel, ButtonBar.ButtonData.CANCEL_CLOSE);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnCancel});
        }
    }

    public void addOkCancelButtons(Button btnOk, Button btnCancel) {
        if (btnCancel != null) {
            ButtonBar.setButtonData(btnCancel, ButtonBar.ButtonData.CANCEL_CLOSE);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnCancel});
        }
        if (btnOk != null) {
            ButtonBar.setButtonData(btnOk, ButtonBar.ButtonData.OK_DONE);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnOk});
        }
    }

    public void addOkCancelApplyButtons(Button btnOk, Button btnCancel, Button btnApply) {
        if (btnOk != null) {
            ButtonBar.setButtonData(btnOk, ButtonBar.ButtonData.OK_DONE);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnOk});
        }
        if (btnCancel != null) {
            ButtonBar.setButtonData(btnCancel, ButtonBar.ButtonData.CANCEL_CLOSE);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnCancel});
        }
        if (btnApply != null) {
            ButtonBar.setButtonData(btnApply, ButtonBar.ButtonData.APPLY);
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btnApply});
        }
    }

    public void addHlpButton(Node btn) {
        if (btn != null) {
            ButtonBar.setButtonData(btn, ButtonBar.ButtonData.HELP);
            this.buttonBar.getButtons().add(btn);
        }
    }

    public void addAnyButton(Node btn) {
        if (btn != null) {
            this.buttonBar.getButtons().addAll((Node[])new Node[]{btn});
        }
    }

    public void setMaskerVisible(boolean visible) {
        if (this.masker) {
            this.maskerPane.setMaskerVisible(visible);
        }
    }

    public P2MaskerPaneMin getMaskerPane() {
        return this.maskerPane;
    }

    private void initDialog() {
        this.initBefore();
        switch (this.deco) {
            case BORDER_BIG: {
                this.initBorderBig();
                break;
            }
            case BORDER: {
                this.initBorder();
                break;
            }
            case BORDER_SMALL: {
                this.initBorderSmall();
                break;
            }
            default: {
                this.initNoBorder();
            }
        }
        this.addBottom();
        P2LibConst.themeChanged.addListener((u, o, n) -> {
            P2Log.debugLog("P2DialogExtra: updateCss");
            super.updateCss();
            P2Image.getAllNodes(this.getStage().getScene().getRoot());
        });
    }

    private void initBefore() {
        if (this.masker) {
            StackPane.setAlignment(this.maskerPane, Pos.CENTER);
            this.maskerPane.setPadding(new Insets(4.0, 1.0, 1.0, 1.0));
            StackPane stackPane = new StackPane();
            super.setPane(stackPane);
            stackPane.getChildren().addAll((Node[])new Node[]{this.vBoxCompleteDialog, this.maskerPane});
        } else {
            super.setPane(this.vBoxCompleteDialog);
        }
        this.vBoxCompleteDialog.setPadding(new Insets(10.0));
        this.hBoxOverAll.setVisible(false);
        this.hBoxOverAll.setManaged(false);
        this.hBoxTitle.setVisible(false);
        this.hBoxTitle.setManaged(false);
        this.hBoxTitle.getStyleClass().add("dialog-title");
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        VBox.setVgrow(this.scrollPane, Priority.ALWAYS);
        this.vBoxCont.setPadding(new Insets(10.0));
        this.scrollPane.setContent(this.vBoxCont);
    }

    private void initBorderBig() {
        VBox vBoxStyledBorder = new VBox();
        vBoxStyledBorder.getStyleClass().add("dialog-border-big");
        VBox.setVgrow(vBoxStyledBorder, Priority.ALWAYS);
        vBoxStyledBorder.getChildren().addAll((Node[])new Node[]{this.scrollPane});
        this.vBoxCompleteDialog.getChildren().addAll((Node[])new Node[]{this.hBoxOverAll, this.hBoxTitle, vBoxStyledBorder});
    }

    private void initBorder() {
        VBox vBoxStyledBorder = new VBox();
        vBoxStyledBorder.getStyleClass().add("dialog-border");
        VBox.setVgrow(vBoxStyledBorder, Priority.ALWAYS);
        vBoxStyledBorder.getChildren().addAll((Node[])new Node[]{this.scrollPane});
        this.vBoxCompleteDialog.getChildren().addAll((Node[])new Node[]{this.hBoxOverAll, this.hBoxTitle, vBoxStyledBorder});
    }

    private void initBorderSmall() {
        VBox vBoxStyledBorder = new VBox();
        vBoxStyledBorder.getStyleClass().add("dialog-border-small");
        VBox.setVgrow(vBoxStyledBorder, Priority.ALWAYS);
        vBoxStyledBorder.getChildren().addAll((Node[])new Node[]{this.scrollPane});
        this.vBoxCompleteDialog.getChildren().addAll((Node[])new Node[]{this.hBoxOverAll, this.hBoxTitle, vBoxStyledBorder});
    }

    private void initNoBorder() {
        this.vBoxCompleteDialog.getChildren().addAll((Node[])new Node[]{this.hBoxOverAll, this.hBoxTitle, this.scrollPane});
    }

    private void addBottom() {
        HBox hButton = new HBox();
        hButton.setAlignment(Pos.CENTER_RIGHT);
        this.hBoxLeft.setAlignment(Pos.CENTER_RIGHT);
        this.hBoxRight.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow(this.hBoxLeft, Priority.ALWAYS);
        hButton.getChildren().addAll((Node[])new Node[]{this.hBoxLeft, this.buttonBar, this.hBoxRight});
        this.vBoxCompleteDialog.getChildren().addAll((Node[])new Node[]{this.hBoxOverButtons, hButton});
    }

    public static enum DECO {
        BORDER_BIG,
        BORDER,
        BORDER_SMALL,
        NO_BORDER;

    }

    public static enum STATE {
        STATE_OK,
        STATE_CANCEL,
        STATE_DOWN_AND_FILE,
        STATE_ONLY_DOWNLOAD;

    }
}

