/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs;

import de.p2tools.p2lib.tools.file.P2FileName;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class P2DirFileChooser {
    public static String FileChooserSelect(Stage stage) {
        return P2DirFileChooser.FileChooserSelect(stage, "", "");
    }

    public static String FileChooserSelect(Stage stage, String initDirStr, String initFileStr) {
        File selectedFile;
        String ret = "";
        File initDir = initDirStr.isEmpty() ? new File(System.getProperty("user.home")) : new File(initDirStr);
        FileChooser fileChooser = new FileChooser();
        if (initDir.exists()) {
            fileChooser.setInitialDirectory(initDir);
        }
        if (!initFileStr.isEmpty()) {
            fileChooser.setInitialFileName(initFileStr);
        }
        if ((selectedFile = fileChooser.showOpenDialog(stage)) != null) {
            try {
                ret = selectedFile.getAbsolutePath();
            }
            catch (Exception ex) {
                P2Log.errorLog(912030654, ex);
            }
        }
        return ret;
    }

    public static String FileChooserSave(Stage stage, String initDirStr, String initFileStr) {
        File selectedFile;
        String ret = "";
        File initDir = initDirStr.isEmpty() ? new File(System.getProperty("user.home")) : new File(initDirStr);
        FileChooser fileChooser = new FileChooser();
        if (initDir.exists()) {
            fileChooser.setInitialDirectory(initDir);
        }
        if (!initFileStr.isEmpty()) {
            fileChooser.setInitialFileName(initFileStr);
        }
        if ((selectedFile = fileChooser.showSaveDialog(stage)) != null) {
            try {
                ret = selectedFile.getAbsolutePath();
            }
            catch (Exception ex) {
                P2Log.errorLog(912030654, ex);
            }
        }
        return ret;
    }

    public static void FileChooserSaveFile(Stage stage, TextField txtFile) {
        File initFile = new File(System.getProperty("user.home"));
        String fileName = "";
        if (!txtFile.getText().isEmpty()) {
            File f = new File(txtFile.getText());
            if (f.isDirectory()) {
                initFile = f;
            } else if (f.isFile()) {
                initFile = f.getParentFile();
                fileName = f.getName();
            }
        }
        FileChooser fileChooser = new FileChooser();
        if (initFile.exists()) {
            fileChooser.setInitialDirectory(initFile);
        }
        fileChooser.setInitialFileName(fileName);
        File selectedFile = fileChooser.showSaveDialog(stage);
        if (selectedFile != null) {
            txtFile.setText(selectedFile.getAbsolutePath());
            if (selectedFile.exists()) {
                selectedFile.delete();
            }
        }
    }

    public static void FileChooserOpenFile(Stage stage, TextField txtFile) {
        File selectedFile;
        FileChooser fileChooser = new FileChooser();
        File initFile = new File(System.getProperty("user.home"));
        if (!txtFile.getText().isEmpty()) {
            File f = new File(txtFile.getText());
            if (f.exists() && f.isDirectory()) {
                initFile = f;
            } else if (f.exists() && f.isFile()) {
                initFile = f.getParentFile();
            }
        }
        if (initFile.exists()) {
            fileChooser.setInitialDirectory(initFile);
        }
        if ((selectedFile = fileChooser.showOpenDialog(stage)) != null) {
            txtFile.setText(selectedFile.getAbsolutePath());
        }
    }

    public static String FileChooser(Stage stage, ComboBox<String> cbPath) {
        return P2DirFileChooser.FileChooser(stage, cbPath, "");
    }

    public static String FileChooser(Stage stage, ComboBox<String> cbPath, String startDir) {
        return P2DirFileChooser.FileChooser(stage, cbPath, startDir, "");
    }

    public static String FileChooser(Stage stage, ComboBox<String> cbPath, String startDir, String relPath) {
        File selectedFile;
        File initDir;
        String ret = "";
        FileChooser fileChooser = new FileChooser();
        if (!startDir.isEmpty()) {
            initDir = new File(startDir);
        } else {
            Path path = null;
            if (cbPath.getSelectionModel().getSelectedItem() != null && !((String)cbPath.getSelectionModel().getSelectedItem()).isEmpty()) {
                path = Paths.get((String)cbPath.getSelectionModel().getSelectedItem(), new String[0]);
            }
            initDir = path != null && path.toFile().exists() && path.toFile().isDirectory() ? path.toFile() : (path != null && path.getParent() != null && path.getParent().toFile().exists() && path.getParent().toFile().isDirectory() ? path.getParent().toFile() : new File(System.getProperty("user.home")));
        }
        if (initDir.exists()) {
            fileChooser.setInitialDirectory(initDir);
        }
        if ((selectedFile = fileChooser.showOpenDialog(stage)) != null) {
            try {
                ret = relPath.isEmpty() ? selectedFile.getAbsolutePath() : P2FileName.getFilenameRelative(selectedFile, relPath);
                if (!cbPath.getItems().contains(ret)) {
                    cbPath.getItems().add(ret);
                }
                cbPath.getSelectionModel().select(ret);
            }
            catch (Exception ex) {
                P2Log.errorLog(912030201, ex);
            }
        }
        return ret;
    }

    public static String FileChooserSave(Stage stage, ComboBox<String> cbPath, String startDir, String initFile) {
        String ret = "";
        FileChooser fileChooser = new FileChooser();
        File initDir = new File(System.getProperty("user.home"));
        String initFileName = "";
        Path path = cbPath.getSelectionModel().getSelectedItem() != null && !((String)cbPath.getSelectionModel().getSelectedItem()).isEmpty() ? Paths.get((String)cbPath.getSelectionModel().getSelectedItem(), new String[0]) : Paths.get(startDir, new String[0]);
        if (path.toFile().exists() && path.toFile().isDirectory()) {
            initDir = path.toFile();
        } else if (path.getParent() != null && path.getParent().toFile().exists() && path.getParent().toFile().isDirectory()) {
            initDir = path.getParent().toFile();
        }
        if (path.toFile().isFile()) {
            initFileName = path.getFileName().toString();
        }
        if (initDir.exists()) {
            fileChooser.setInitialDirectory(initDir);
        }
        fileChooser.setInitialFileName(initFileName.isEmpty() ? initFile : initFileName);
        File selectedFile = fileChooser.showSaveDialog(stage);
        if (selectedFile != null) {
            try {
                ret = selectedFile.getAbsolutePath();
                if (!cbPath.getItems().contains(ret)) {
                    cbPath.getItems().add(ret);
                }
                cbPath.getSelectionModel().select(ret);
            }
            catch (Exception ex) {
                P2Log.errorLog(912030201, ex);
            }
        }
        return ret;
    }

    public static String DirChooser(Stage stage, String txtPath) {
        File selectedFile;
        File f;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File initFile = new File(System.getProperty("user.home"));
        if (!txtPath.isEmpty() && (f = new File(txtPath)).exists() && f.isDirectory()) {
            initFile = new File(txtPath);
        }
        if (initFile.exists()) {
            directoryChooser.setInitialDirectory(initFile);
        }
        if ((selectedFile = directoryChooser.showDialog(stage)) != null) {
            return selectedFile.getAbsolutePath();
        }
        return "";
    }

    public static String DirChooser(Stage stage, TextField txtPath) {
        File selectedFile;
        File f;
        String ret = "";
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File initFile = new File(System.getProperty("user.home"));
        if (!txtPath.getText().isEmpty() && (f = new File(txtPath.getText())).exists() && f.isDirectory()) {
            initFile = new File(txtPath.getText());
        }
        if (initFile.exists()) {
            directoryChooser.setInitialDirectory(initFile);
        }
        if ((selectedFile = directoryChooser.showDialog(stage)) != null) {
            ret = selectedFile.getAbsolutePath();
            txtPath.setText(selectedFile.getAbsolutePath());
        }
        return ret;
    }

    public static String DirChooser(Stage stage, ComboBox<String> cbPath) {
        return P2DirFileChooser.DirChooser(stage, cbPath, "");
    }

    public static String DirChooser(Stage stage, ComboBox<String> cbPath, String startDir) {
        File selectedDir;
        File f;
        File initFile;
        String ret = "";
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File file = initFile = startDir.isEmpty() ? new File(System.getProperty("user.home")) : new File(startDir);
        if (cbPath.getSelectionModel().getSelectedItem() != null && !((String)cbPath.getSelectionModel().getSelectedItem()).isEmpty() && (f = new File((String)cbPath.getSelectionModel().getSelectedItem())).exists() && f.isDirectory()) {
            initFile = new File((String)cbPath.getSelectionModel().getSelectedItem());
        }
        if (initFile.exists()) {
            directoryChooser.setInitialDirectory(initFile);
        }
        if ((selectedDir = directoryChooser.showDialog(stage)) != null) {
            try {
                ret = selectedDir.getAbsolutePath();
                if (!cbPath.getItems().contains(ret)) {
                    if (cbPath.getItems().size() > 0 && ((String)cbPath.getItems().get(0)).equals("")) {
                        cbPath.getItems().add(1, ret);
                    } else {
                        cbPath.getItems().add(0, ret);
                    }
                }
                cbPath.getSelectionModel().select(ret);
            }
            catch (Exception ex) {
                P2Log.errorLog(912365478, ex);
            }
        }
        return ret;
    }
}

