/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.atdata;

import de.p2tools.p2lib.atdata.AudioDataProps;
import de.p2tools.p2lib.atdata.AudioList;
import de.p2tools.p2lib.tools.date.P2DateGmtFactory;
import java.time.Duration;
import java.time.LocalDateTime;

public class AudioListFactory {
    public static final String DATE_TIME_FORMAT = "dd.MM.yyyy HH:mm:ss";

    private AudioListFactory() {
    }

    public static int getAge(String[] metaData) {
        int ret = AudioListFactory.get(metaData);
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    private static int get(String[] metaData) {
        if (!metaData[AudioList.META_GMT].isEmpty()) {
            Duration dur = Duration.between(AudioListFactory.getDate(metaData), LocalDateTime.now());
            return (int)dur.toSeconds();
        }
        Duration dur = Duration.between(AudioListFactory.getDate(metaData), LocalDateTime.now());
        return (int)dur.toSeconds();
    }

    public static LocalDateTime getDate(String[] metaData) {
        if (!metaData[AudioList.META_GMT].isEmpty()) {
            return P2DateGmtFactory.getLocalDateTimeFromGmt(metaData[AudioList.META_GMT]);
        }
        return P2DateGmtFactory.getLocalDateTimeFromGmt(metaData[AudioList.META_LOCAL]);
    }

    public static synchronized long countNewAudios(AudioList audioList) {
        return audioList.stream().filter(AudioDataProps::isNewAudio).count();
    }
}

