/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.atdata;

import de.p2tools.p2lib.atdata.AudioDataProps;
import de.p2tools.p2lib.atdata.AudioDataXml;
import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.pdata.P2Data;
import de.p2tools.p2lib.mtfilm.film.Data;
import de.p2tools.p2lib.mtfilm.tools.FilmDate;
import de.p2tools.p2lib.tools.log.P2Log;

public class AudioData
extends AudioDataProps
implements P2Data {
    public String CHANNEL_STR = "";
    public String GENRE_STR = "";
    public String THEME_STR = "";
    public String TITLE_STR = "";

    @Override
    public String getTag() {
        return "";
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public Config[] getConfigsArr() {
        return null;
    }

    public void init() {
        this.setNewAudio(Boolean.parseBoolean(this.arr[14]));
        this.setPodcast(Boolean.parseBoolean(this.arr[15]));
        this.setDoubleUrl(Boolean.parseBoolean(this.arr[16]));
        this.preserveMemory();
        this.audioSize.setAudioSize(this.arr[10]);
        this.setLength();
        this.setDate();
    }

    private void preserveMemory() {
        this.arr[7] = this.arr[7].intern();
    }

    public void setLowerCase() {
        this.CHANNEL_STR = this.getChannel().toLowerCase();
        this.GENRE_STR = this.getGenre().toLowerCase();
        this.THEME_STR = this.getTheme().toLowerCase();
        this.TITLE_STR = this.getTitle().toLowerCase();
    }

    public void clearLowerCase() {
        this.CHANNEL_STR = "";
        this.GENRE_STR = "";
        this.THEME_STR = "";
        this.TITLE_STR = "";
    }

    private void setLength() {
        try {
            long durSecond = 0L;
            if (!this.arr[9].isEmpty()) {
                String[] parts = this.arr[9].split(":");
                long power = 1L;
                for (int i = parts.length - 1; i >= 0; --i) {
                    durSecond += Long.parseLong(parts[i]) * power;
                    power *= 60L;
                }
            }
            this.setDur(durSecond);
        }
        catch (Exception ex) {
            this.setDur(0L);
            P2Log.errorLog(201659701, "Dauer: " + this.arr[9]);
        }
    }

    private void setDur(long durSecond) {
        if (durSecond <= 0L) {
            this.setDurationMinute(0);
            return;
        }
        int d = (int)(durSecond / 60L);
        if (d <= 0) {
            d = 1;
        }
        this.setDurationMinute(d);
    }

    private void setDate() {
        this.date.setTime(0L);
        if (!this.arr[7].isEmpty()) {
            try {
                if (this.arr[17].isEmpty()) {
                    this.date = new FilmDate(sdf_date.parse(this.arr[7]).getTime());
                    this.arr[17] = String.valueOf(this.date.getTime() / 1000L);
                } else {
                    long l = Long.parseLong(this.arr[17]);
                    this.date = new FilmDate(l * 1000L);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(915236701, ex, new String[]{"Datum: " + this.arr[7]});
                this.date = new FilmDate(0L);
                this.arr[7] = "";
            }
        }
    }

    @Override
    public int compareTo(AudioDataXml arg0) {
        int ret = Data.sorter.compare(this.arr[1], arg0.arr[1]);
        if (ret == 0 && (ret = Data.sorter.compare(this.arr[2], arg0.arr[2])) == 0) {
            return Data.sorter.compare(this.arr[3], arg0.arr[3]);
        }
        return ret;
    }

    public AudioData getCopy() {
        AudioData ret = new AudioData();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.date = this.date;
        ret.no = this.no;
        ret.audioSize = this.audioSize;
        ret.setDurationMinute(this.getDurationMinute());
        return ret;
    }
}

