/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmPlayFactory;
import de.p2tools.mtplayer.controller.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class CellFilmButton<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<FilmDataMTP, String>, TableCell<FilmDataMTP, String>> cellFactory = param -> {
        TableCell<FilmDataMTP, String> cell = new TableCell<FilmDataMTP, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(4.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Button btnPlay = new Button("");
                btnPlay.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnPlay.setGraphic(ProgIcons.IMAGE_TABLE_FILM_PLAY.getImageView());
                Button btnSave = new Button("");
                btnSave.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnSave.setGraphic(ProgIcons.IMAGE_TABLE_FILM_SAVE.getImageView());
                Button btnBookmark = new Button("");
                btnBookmark.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnBookmark.setGraphic(ProgIcons.IMAGE_TABLE_FILM_BOOKMARK.getImageView());
                if (ProgConfig.SYSTEM_SMALL_ROW_TABLE_FILM.get()) {
                    btnPlay.setMaxHeight(18.0);
                    btnPlay.setMinHeight(18.0);
                    btnSave.setMaxHeight(18.0);
                    btnSave.setMinHeight(18.0);
                    btnBookmark.setMaxHeight(18.0);
                    btnBookmark.setMinHeight(18.0);
                }
                btnPlay.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                    FilmPlayFactory.playFilm(film);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                btnSave.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                    FilmSaveFactory.saveFilm(film);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                btnBookmark.setOnAction(e -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    FilmDataMTP film = (FilmDataMTP)this.getTableView().getItems().get(this.getIndex());
                    FilmToolsFactory.changeBookmarkFilm(film);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                hbox.getChildren().addAll((Node[])new Node[]{btnPlay, btnSave, btnBookmark});
                this.setGraphic(hbox);
            }
        };
        return cell;
    };
}

