/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class CellAboButton<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<AboData, String>, TableCell<AboData, String>> cellFactory = param -> {
        TableCell<AboData, String> cell = new TableCell<AboData, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(4.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                AboData aboData = (AboData)this.getTableView().getItems().get(this.getIndex());
                Button btnActivate = new Button("");
                btnActivate.setTooltip(new Tooltip("Abo ein- oder ausschalten"));
                btnActivate.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                if (aboData.isActive()) {
                    btnActivate.setGraphic(ProgIcons.IMAGE_TABLE_ABO_OFF.getImageView());
                } else {
                    btnActivate.setGraphic(ProgIcons.IMAGE_TABLE_ABO_ON.getImageView());
                }
                btnActivate.setOnAction(a -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    ProgData.getInstance().aboList.setAboActive(aboData, !aboData.isActive());
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                Button btnDel = new Button("");
                btnDel.setTooltip(new Tooltip("Abo l\u00f6schen"));
                btnDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnDel.setGraphic(ProgIcons.IMAGE_TABLE_ABO_DEL.getImageView());
                btnDel.setOnAction(a -> {
                    this.getTableView().getSelectionModel().clearSelection();
                    this.getTableView().getSelectionModel().select(this.getIndex());
                    AboListFactory.deleteAbo(aboData);
                    this.getTableView().refresh();
                    this.getTableView().requestFocus();
                });
                if (ProgConfig.SYSTEM_SMALL_ROW_TABLE_ABO.get()) {
                    btnActivate.setMaxHeight(18.0);
                    btnActivate.setMinHeight(18.0);
                    btnDel.setMaxHeight(18.0);
                    btnDel.setMinHeight(18.0);
                }
                hbox.getChildren().addAll((Node[])new Node[]{btnActivate, btnDel});
                this.setGraphic(hbox);
            }
        };
        return cell;
    };
}

