/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools;

import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.config.ProxyFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.mtdownload.TimedTextMarkupLanguageParser;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.PUrlTools;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class MTSubtitle {
    private static final int TIMEOUT = 10000;
    private static final String SUFFIX_TTML = "ttml";
    private static final String SUFFIX_SRT = "srt";
    private static final String SRT_FILETYPE = ".srt";
    private static final String SUFFIX_VTT = "vtt";

    private InputStream getContentDecoder(String encoding, InputStream in) throws IOException {
        if (encoding != null) {
            InflaterInputStream out = null;
            switch (encoding.toLowerCase()) {
                case "gzip": {
                    out = new GZIPInputStream(in);
                    break;
                }
                case "deflate": {
                    out = new InflaterInputStream(in, new Inflater(true));
                }
            }
            return out;
        }
        return in;
    }

    private void setupConnection(HttpURLConnection conn) {
        conn.setRequestProperty("User-Agent", ProgInfos.getUserAgent());
        conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.setReadTimeout(10000);
        conn.setConnectTimeout(10000);
    }

    private void downloadContent(InputStream in, String strSubtitelFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(strSubtitelFile);){
            int n;
            byte[] buffer = new byte[65536];
            while ((n = in.read(buffer)) != -1) {
                fos.write(buffer, 0, n);
            }
            P2Log.sysLog(new String[]{"Untertitel", "  geschrieben"});
        }
    }

    private void writeSrt(String strSubtitelFile, DownloadData download) {
        TimedTextMarkupLanguageParser ttmlp = new TimedTextMarkupLanguageParser();
        Path p = Paths.get(strSubtitelFile, new String[0]);
        if (ttmlp.parse(p) || ttmlp.parseXmlFlash(p)) {
            Path srt = MTSubtitle.getSrtPath(download);
            ttmlp.toSrt(srt);
        }
        ttmlp.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSubtitle(DownloadData download) {
        String urlSubtitle = download.getUrlSubtitle();
        InputStream in = null;
        if (urlSubtitle.isEmpty()) {
            return;
        }
        try {
            P2Log.sysLog(new String[]{"Untertitel: ", download.getUrlSubtitle(), "schreiben nach: ", download.getDestPath()});
            Files.createDirectories(Paths.get(download.getDestPath(), new String[0]), new FileAttribute[0]);
            HttpURLConnection conn = ProxyFactory.getUrlConnection(urlSubtitle);
            this.setupConnection(conn);
            if (conn.getResponseCode() < 400) {
                in = this.getContentDecoder(conn.getContentEncoding(), conn.getInputStream());
                String strSubtitelFile = MTSubtitle.getSubtitleStr(download);
                this.downloadContent(in, strSubtitelFile);
                if (!strSubtitelFile.endsWith(SRT_FILETYPE) && !strSubtitelFile.endsWith(".vtt")) {
                    this.writeSrt(strSubtitelFile, download);
                }
            } else {
                P2Log.errorLog(752301248, "url: " + urlSubtitle);
            }
        }
        catch (Exception ignored) {
            P2Log.errorLog(461203210, ignored, "SubtitelUrl: " + urlSubtitle);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String getSubtitleStr(DownloadData download) {
        String suffix = PUrlTools.getSuffixFromUrl(download.getUrlSubtitle());
        if (!suffix.endsWith(SUFFIX_SRT) && !suffix.endsWith(SUFFIX_VTT)) {
            suffix = SUFFIX_TTML;
        }
        return download.getPathFileNameWithoutSuffix() + "." + suffix;
    }

    public static Path getSubtitlePath(DownloadData download) {
        Path path;
        try {
            path = Paths.get(MTSubtitle.getSubtitleStr(download), new String[0]);
        }
        catch (Exception ex) {
            path = null;
            P2Log.errorLog(951245412, "SubtitlePath");
        }
        return path;
    }

    public static Path getSrtPath(DownloadData download) {
        return Paths.get(download.getPathFileNameWithoutSuffix() + SRT_FILETYPE, new String[0]);
    }
}

