/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.startdialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.film.FilmToolsFactory;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.mtfilm.tools.LoadFactoryConst;
import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class StartPaneStation {
    private final Button btnClearAll = new Button("_Wieder alle Sender laden");
    private final Stage stage;

    public StartPaneStation(Stage stage) {
        this.stage = stage;
    }

    public void close() {
    }

    public TitledPane make() {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.makeSender(vBox);
        return new TitledPane("Filmliste bereits beim Laden filtern", vBox);
    }

    private void makeSender(VBox vBox) {
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        Label lbl = new Label("Hier k\u00f6nnen Sender die *nicht* interessieren, beim Laden der Filmliste, ausgenommen werden.");
        lbl.setWrapText(true);
        lbl.setPrefWidth(500.0);
        hBox.getChildren().add(lbl);
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(5), hBox, P2GuiTools.getVDistance(20)});
        Button btnHelpSender = P2Button.helpButton(this.stage, "Filmliste beim Laden filtern", "Filme der markierten Sender werden beim Laden der Filmliste ausgeschlossen.\n\n");
        HBox hBoxStation = new HBox(5.0);
        hBoxStation.setAlignment(Pos.CENTER_LEFT);
        Label lblStation = new Label("Diese Sender  *nicht*  laden:");
        hBoxStation.getChildren().addAll((Node[])new Node[]{lblStation, P2GuiTools.getHBoxGrower(), this.btnClearAll, btnHelpSender});
        vBox.getChildren().add(hBoxStation);
        TilePane tilePaneSender = this.getTilePaneSender();
        vBox.getChildren().addAll((Node[])new Node[]{tilePaneSender});
    }

    private TilePane getTilePaneSender() {
        TilePane tilePaneSender = new TilePane();
        tilePaneSender.setHgap(5.0);
        tilePaneSender.setVgap(5.0);
        ArrayList<String> aListChannel = FilmToolsFactory.getSenderListNotToLoad();
        ArrayList<CheckBox> aListCb = new ArrayList<CheckBox>();
        for (String s : LoadFactoryConst.SENDER) {
            CheckBox cb = new CheckBox(s);
            aListCb.add(cb);
            cb.setSelected(aListChannel.contains(s));
            cb.setOnAction(a -> {
                this.makePropSender(aListCb);
                FilmToolsFactory.checkAllSenderSelectedNotToLoad(this.stage);
            });
            tilePaneSender.getChildren().add(cb);
            TilePane.setAlignment(cb, Pos.CENTER_LEFT);
        }
        this.btnClearAll.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnClearAll.setOnAction(a -> {
            aListCb.stream().forEach(checkBox -> checkBox.setSelected(false));
            this.makePropSender(aListCb);
        });
        this.checkPropSender(aListCb);
        return tilePaneSender;
    }

    private void checkPropSender(ArrayList<CheckBox> aListCb) {
        boolean noneChecked = true;
        for (CheckBox cb : aListCb) {
            if (!cb.isSelected()) continue;
            noneChecked = false;
            break;
        }
        this.btnClearAll.setDisable(noneChecked);
    }

    private void makePropSender(ArrayList<CheckBox> aListCb) {
        String str = "";
        for (CheckBox cb : aListCb) {
            if (!cb.isSelected()) continue;
            String s = cb.getText();
            str = str.isEmpty() ? s : str + "," + s;
        }
        ProgConfig.SYSTEM_LOAD_NOT_SENDER.setValue(str);
        this.checkPropSender(aListCb);
    }
}

