/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.startdialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class StartPaneFilm {
    private final Slider slDays = new Slider();
    private final Slider slDuration = new Slider();
    private final Label lblDays = new Label("");
    private final Label lblDuration = new Label("");
    private final Stage stage;

    public StartPaneFilm(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.slDays.valueProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MAX_DAYS);
        this.slDuration.valueProperty().unbindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MIN_DURATION);
    }

    public TitledPane make() {
        this.initSlider();
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.makeOnly(vBox);
        return new TitledPane("Filmliste bereits beim Laden filtern", vBox);
    }

    private void makeOnly(VBox vBox) {
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        Label lbl = new Label("Die Filmliste enth\u00e4lt inzwischen ~ 800_000 Filme. Davon sind etwa 150_000 doppelt (z.B. ARD und BR). Es ist also eine gute Idee, die doppelten nicht zu laden und eventuell auch alte Filme nicht mehr zu laden. Auf \u00e4lteren Rechnern ist die Suche dann schneller.");
        lbl.setWrapText(true);
        lbl.setPrefWidth(500.0);
        hBox.getChildren().add(lbl);
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(5), hBox, P2GuiTools.getVDistance(20)});
        Button btnHelpDouble = P2Button.helpButton(this.stage, "Filmliste beim Laden filtern", "In der Filmliste sind ~150.000 Filme doppelt enthalten (z.B. bei ARD und BR).\n\nDoppelte k\u00f6nnen bereits beim Laden der Filmliste ausgefiltert werden. Da die Filmliste inzwischen sehr lang ist, w\u00e4re das eine sehr gute Entscheidung. In den Einstellungen kann das auch wieder ge\u00e4ndert werden.\n");
        Button btnHelpDays = P2Button.helpButton(this.stage, "Filmliste beim Laden filtern", "\"Nur Filme der letzten Tage laden\"\nDie Filmliste enth\u00e4lt dann nur Filme aus diesem Zeitraum. Filme ohne Datum sind immer enthalten.\n\n\"Nur Filme mit Mindestl\u00e4nge laden\"\nDie Filmliste enth\u00e4lt dann nur Filme von mindestens dieser Dauer. Filme ohne L\u00e4ngenangabe sind immer enthalten.\n\nBei 'alles laden' sind alle Filme enthalten.\n\nDas Filtern der Filmliste kann bei \u00e4lteren Rechnern mit wenig Speicher hilfreich sein: Bei 'maximal 250 Tage' oder 'mindestens 5 Minuten' ist die Filmliste nur etwa halb so gro\u00df (~300.000 Filme).\n");
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        int row = 0;
        P2ToggleSwitch tglRemove = new P2ToggleSwitch("Doppelte Filme beim Laden der Filmliste ausschlie\u00dfen");
        ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE.setValue(Boolean.TRUE);
        tglRemove.setSelected(ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE.getValue());
        tglRemove.selectedProperty().addListener((u, o, n) -> ProgConfig.SYSTEM_FILMLIST_REMOVE_DOUBLE.setValue(tglRemove.isSelected()));
        gridPane.add(tglRemove, 0, row, 3, 1);
        gridPane.add(btnHelpDouble, 3, row);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(new Label("Nur Filme der letzten Tage laden:"), 0, ++row, 2, 1);
        gridPane.add(new Label("Filme laden:"), 0, ++row);
        gridPane.add(this.slDays, 1, row);
        gridPane.add(this.lblDays, 2, row);
        gridPane.add(btnHelpDays, 3, row, 1, 2);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(new Label("Nur Filme mit Mindestl\u00e4nge laden:"), 0, ++row, 2, 1);
        gridPane.add(new Label("Filme laden:"), 0, ++row);
        gridPane.add(this.slDuration, 1, row);
        gridPane.add(this.lblDuration, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        vBox.getChildren().add(gridPane);
    }

    private void initSlider() {
        this.slDays.setMin(0.0);
        this.slDays.setMax(300.0);
        this.slDays.setShowTickLabels(false);
        this.slDays.setMajorTickUnit(100.0);
        this.slDays.setBlockIncrement(5.0);
        this.slDays.valueProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MAX_DAYS);
        this.slDays.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValueSlider());
        if (ProgData.debug) {
            this.slDays.setValue(100.0);
        }
        this.slDuration.setMin(0.0);
        this.slDuration.setMax(30.0);
        this.slDuration.setShowTickLabels(false);
        this.slDuration.setMajorTickUnit(10.0);
        this.slDuration.setBlockIncrement(1.0);
        this.slDuration.valueProperty().bindBidirectional(ProgConfig.SYSTEM_LOAD_FILMLIST_MIN_DURATION);
        this.slDuration.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValueSlider());
        this.setValueSlider();
    }

    private void setValueSlider() {
        int days = (int)this.slDays.getValue();
        this.lblDays.setText((String)(days == 0 ? "alles laden" : "nur Filme der letzten " + days + " Tage"));
        int duration = (int)this.slDuration.getValue();
        this.lblDuration.setText((String)(duration == 0 ? "alles laden" : "nur Filme mit mindestens " + duration + " Minuten L\u00e4nge"));
    }
}

