/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.startdialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class StartPaneDownloadPath {
    private final TextField txtPath = new TextField();
    private final Stage stage;

    public StartPaneDownloadPath(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.txtPath.textProperty().unbindBidirectional(ProgConfig.DOWNLOAD_PATH);
    }

    public TitledPane makePath() {
        VBox vBox = new VBox(10.0);
        HBox hBox = new HBox();
        hBox.getStyleClass().add("extra-pane");
        hBox.setPadding(new Insets(10.0));
        hBox.setMaxWidth(Double.MAX_VALUE);
        hBox.setMinHeight(Double.NEGATIVE_INFINITY);
        Label lbl = new Label("Der Ordner, der beim Speichern vorgeschlagen wird, kann hier ausgew\u00e4hlt werden.");
        lbl.setWrapText(true);
        lbl.setPrefWidth(500.0);
        hBox.getChildren().add(lbl);
        vBox.getChildren().addAll((Node[])new Node[]{P2GuiTools.getVDistance(5), hBox, P2GuiTools.getVDistance(20)});
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        if (ProgData.debug) {
            ProgConfig.DOWNLOAD_PATH.setValue("/tmp/Download");
        }
        this.txtPath.textProperty().bindBidirectional(ProgConfig.DOWNLOAD_PATH);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(this.stage, this.txtPath));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Pfad zum Speichern ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Zielverzeichnis", "Hier kann das Verzeichnis angegeben werden, in dem die Downloads gespeichert werden.");
        int row = 0;
        gridPane.add(new Label("Pfad:"), 0, row);
        gridPane.add(this.txtPath, 1, row);
        gridPane.add(btnFile, 2, row);
        gridPane.add(btnHelp, 3, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(gridPane);
        return new TitledPane("Pfad f\u00fcr die Downloads", vBox);
    }
}

