/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediadialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.stage.Stage;

public class PaneMediaContextMenu {
    private final ProgData progData;
    private final MediaData mediaData;
    private final Stage stage;

    public PaneMediaContextMenu(Stage stage, MediaData mediaData) {
        this.stage = stage;
        this.mediaData = mediaData;
        this.progData = ProgData.getInstance();
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu) {
        MenuItem miOpen = new MenuItem("Speicherort des Film im Dateimanager \u00f6ffnen");
        miOpen.setOnAction(a -> {
            String path = this.mediaData.getPath();
            if (!path.isEmpty()) {
                P2Open.openDir(path, ProgConfig.SYSTEM_PROG_OPEN_DIR, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
            }
        });
        MenuItem miPlay = new MenuItem("Gespeicherten Film abspielen");
        miPlay.setOnAction(a -> {
            String path = this.mediaData.getPath();
            String name = this.mediaData.getName();
            if (!path.isEmpty() && !name.isEmpty()) {
                P2Open.playStoredFilm(P2FileUtils.addsPath(path, name), ProgConfig.SYSTEM_PROG_PLAY_FILME, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
            }
        });
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miOpen, miPlay});
    }
}

