/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediadialog;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.history.HistoryData;
import de.p2tools.mtplayer.gui.dialog.FilmInfoDialogController;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import java.util.ArrayList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.stage.Stage;

public class PaneHistoryContextMenu {
    private final ProgData progData;
    private final ArrayList<HistoryData> historyDataArrayList;
    private final boolean history;
    private final Stage stage;

    public PaneHistoryContextMenu(Stage stage, ArrayList<HistoryData> historyDataArrayList, boolean history) {
        this.stage = stage;
        this.historyDataArrayList = historyDataArrayList;
        this.history = history;
        this.progData = ProgData.getInstance();
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu) {
        FilmDataMTP film = this.progData.filmList.getFilmByUrl(this.historyDataArrayList.get(0).getUrl());
        MenuItem miDelUrl = new MenuItem("Url aus der Liste l\u00f6schen");
        miDelUrl.setOnAction(a -> {
            if (this.history) {
                this.progData.historyList.removeHistoryDataFromHistory(this.historyDataArrayList);
            } else {
                this.progData.historyListAbos.removeHistoryDataFromHistory(this.historyDataArrayList);
            }
        });
        MenuItem miCopyUrl = new MenuItem("URL kopieren");
        miCopyUrl.setOnAction(a -> {
            Object str = "";
            for (HistoryData historyData : this.historyDataArrayList) {
                str = (String)str + (String)(((String)str).isEmpty() ? historyData.getUrl() : P2LibConst.LINE_SEPARATOR + historyData.getUrl());
            }
            P2ToolsFactory.copyToClipboard((String)str);
        });
        MenuItem miShowFilm = new MenuItem("Infos zum Film anzeigen");
        miShowFilm.setDisable(film == null);
        miShowFilm.setOnAction(a -> {
            FilmInfoDialogController.getInstance().setFilm(film);
            FilmInfoDialogController.getInstanceAndShow().showFilmInfo();
        });
        MenuItem miDownload = new MenuItem("Download noch einmal anlegen");
        miDownload.setDisable(film == null);
        miDownload.setOnAction(a -> FilmSaveFactory.saveFilm(film));
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miDelUrl, miCopyUrl, miShowFilm, miDownload});
    }
}

