/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediadialog;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.history.HistoryData;
import de.p2tools.mtplayer.controller.mediadb.MediaData;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediaSearch.MediaSearchFactory;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.mtfilter.FilterCheckRegEx;
import de.p2tools.p2lib.p2event.P2Listener;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class PaneDialogScrollPane
extends ScrollPane {
    Text textSearch = new Text();
    Button btnCreateMediaDB = new Button("_Mediensammlung neu aufbauen");
    Button btnPlay = new Button();
    Button btnOpen = new Button();
    final Button btnClearList = new Button("_Gesamte Liste l\u00f6schen");
    final Button btnClearSelection = new Button("_Auswahl l\u00f6schen");
    TextField txtSearch = new TextField();
    ProgressBar progress = new ProgressBar();
    private final Button btnStopSearching = new Button();
    Label lblGesamtMedia = new Label();
    Label lblHits = new Label();
    TableView<MediaData> tableMedia = new TableView();
    TableView<HistoryData> tableAboOrHistory = new TableView();
    TextField txtTitleMedia = new TextField();
    TextField txtPathMedia = new TextField();
    private final P2Listener listenerDbStart;
    private final P2Listener listenerDbStop;
    private final boolean mediaDataExist;
    private final ProgData progData = ProgData.getInstance();
    ChangeListener sizeListener;
    ListChangeListener<HistoryData> listener;
    final MediaDataDto mediaDataDto;

    public PaneDialogScrollPane(MediaDataDto mediaDataDto) {
        this.mediaDataDto = mediaDataDto;
        this.mediaDataExist = !mediaDataDto.searchTheme.isEmpty() || !mediaDataDto.searchTitle.isEmpty();
        this.listenerDbStart = new P2Listener(PEvents.EVENT_MEDIA_DB_START){

            @Override
            public void pingGui() {
                PaneDialogScrollPane.this.txtSearch.setDisable(true);
            }
        };
        this.listenerDbStop = new P2Listener(PEvents.EVENT_MEDIA_DB_STOP){

            @Override
            public void pingGui() {
                PaneDialogScrollPane.this.txtSearch.setDisable(false);
                PaneDialogScrollPane.this.filter();
            }
        };
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Medien", vBox);
        result.add(tpConfig);
        vBox.getChildren().add(this);
        VBox.setVgrow(this, Priority.ALWAYS);
        this.make();
    }

    public void make() {
        this.initPanel();
        this.initTable();
        this.initAction();
        this.filter();
    }

    public void close() {
        this.progData.pEventHandler.removeListener(this.listenerDbStart);
        this.progData.pEventHandler.removeListener(this.listenerDbStop);
    }

    private void initPanel() {
        this.txtTitleMedia.setEditable(false);
        this.txtPathMedia.setEditable(false);
        VBox vBoxMedia = new VBox(10.0);
        if (this.mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_MEDIA) {
            this.tableMedia.setMinHeight(200.0);
            VBox.setVgrow(this.tableMedia, Priority.ALWAYS);
            HBox hBox = new HBox(10.0);
            hBox.getChildren().addAll((Node[])new Node[]{this.getHBoxProgress(), P2GuiTools.getHBoxGrower(), this.getHBoxSum()});
            vBoxMedia.getChildren().addAll((Node[])new Node[]{this.getVBoxSearch(), this.tableMedia, hBox, this.getTextFieldGrid()});
        } else {
            this.tableAboOrHistory.setMinHeight(200.0);
            VBox.setVgrow(this.tableAboOrHistory, Priority.ALWAYS);
            HBox hBox = new HBox(10.0);
            hBox.getChildren().addAll((Node[])new Node[]{this.btnClearList, this.btnClearSelection, P2GuiTools.getHBoxGrower(), this.getHBoxSum()});
            vBoxMedia.getChildren().addAll((Node[])new Node[]{this.getVBoxSearch(), this.tableAboOrHistory, hBox, this.getTextFieldGrid()});
        }
        this.setPadding(new Insets(10.0));
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setContent(vBoxMedia);
    }

    private VBox getVBoxSearch() {
        Button btnReset = new Button("");
        btnReset.setGraphic(ProgIcons.ICON_BUTTON_RESET.getImageView());
        btnReset.setTooltip(new Tooltip("Suchtext wieder herstellen"));
        btnReset.setOnAction(a -> this.txtSearch.setText(this.mediaDataDto.searchTheme + " " + this.mediaDataDto.searchTitle));
        Button btnClear = new Button();
        btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnClear.setTooltip(new Tooltip("Das Suchfeld l\u00f6schen"));
        btnClear.setOnAction(a -> this.txtSearch.clear());
        VBox vBoxSearch = MediaSearchFactory.getSearchVbox(this.mediaDataDto, null, false);
        this.mediaDataDto.searchInWhat.addListener((u, o, n) -> this.filter());
        HBox.setHgrow(this.txtSearch, Priority.ALWAYS);
        HBox hBoxSearch = new HBox(10.0);
        hBoxSearch.setPadding(new Insets(0.0));
        hBoxSearch.setAlignment(Pos.CENTER_RIGHT);
        if (this.mediaDataExist) {
            hBoxSearch.getChildren().addAll((Node[])new Node[]{new Label("Suchen: "), this.txtSearch, btnReset, btnClear});
        } else {
            hBoxSearch.getChildren().addAll((Node[])new Node[]{new Label("Suchen: "), this.txtSearch, btnClear});
        }
        vBoxSearch.getChildren().addAll((Node[])new Node[]{hBoxSearch});
        return vBoxSearch;
    }

    private GridPane getTextFieldGrid() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        if (this.mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_MEDIA) {
            gridPane.add(new Label("Titel:"), 0, 0);
            gridPane.add(this.txtTitleMedia, 1, 0);
            gridPane.add(this.btnPlay, 2, 0);
            gridPane.add(new Label("Pfad:"), 0, 1);
            gridPane.add(this.txtPathMedia, 1, 1);
            gridPane.add(this.btnOpen, 2, 1);
        } else {
            gridPane.add(new Label("Titel:"), 0, 0);
            gridPane.add(this.txtTitleMedia, 1, 0);
            gridPane.add(new Label("Url:"), 0, 1);
            gridPane.add(this.txtPathMedia, 1, 1);
        }
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        return gridPane;
    }

    private HBox getHBoxSum() {
        HBox hBoxSum = new HBox(5.0);
        hBoxSum.getChildren().addAll((Node[])new Node[]{this.lblHits, new Label(" von: "), this.lblGesamtMedia});
        return hBoxSum;
    }

    private HBox getHBoxProgress() {
        HBox hBoxProgress = new HBox(10.0);
        hBoxProgress.setPadding(new Insets(0.0));
        hBoxProgress.setAlignment(Pos.CENTER_RIGHT);
        this.progress.setVisible(false);
        this.progress.setMaxHeight(Double.MAX_VALUE);
        this.progress.setMaxWidth(Double.MAX_VALUE);
        this.btnStopSearching.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnStopSearching.setOnAction(event -> this.progData.mediaDataList.setStopSearching(true));
        this.btnStopSearching.visibleProperty().bind(this.progData.mediaDataList.searchingProperty());
        hBoxProgress.getChildren().addAll((Node[])new Node[]{this.btnCreateMediaDB, this.progress, this.btnStopSearching});
        HBox.setHgrow(this.progress, Priority.ALWAYS);
        return hBoxProgress;
    }

    void initTable() {
    }

    void initAction() {
        FilterCheckRegEx filterCheckRegEx = new FilterCheckRegEx(this.txtSearch);
        this.txtSearch.textProperty().addListener((observable2, oldValue, newValue) -> {
            filterCheckRegEx.checkPattern();
            this.filter();
            this.mediaDataDto.searchStringProp.setValue(this.txtSearch.getText());
        });
        this.txtSearch.setOnMouseClicked(event -> {
            if (event.getClickCount() > 1) {
                String sel = this.txtSearch.getSelectedText();
                this.txtSearch.setText(sel);
            }
        });
        this.progData.pEventHandler.addListener(this.listenerDbStart);
        this.progData.pEventHandler.addListener(this.listenerDbStop);
    }

    void filter(String searStr) {
        this.txtSearch.setText(searStr);
        this.filter();
    }

    public void filter() {
    }
}

