/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediacleaningdialog;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class PaneCleaningConfigController {
    private final ProgData progData;
    private final Stage stage;
    private final MediaDataDto mediaDataDto;
    private final P2ToggleSwitch tglExact = new P2ToggleSwitch("Exakt den Begriff suchen");
    private final P2ToggleSwitch tglClean = new P2ToggleSwitch("Putzen");
    private final P2ToggleSwitch tglList = new P2ToggleSwitch("Zus\u00e4tzlich Cleaning-Liste anwenden");
    private final P2ToggleSwitch tglAndOr = new P2ToggleSwitch("Suchbegriffe verkn\u00fcpfen mit UND [sonst ODER]");

    public PaneCleaningConfigController(Stage stage, MediaDataDto mediaDataDto) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
        this.mediaDataDto = mediaDataDto;
    }

    public void close() {
        this.tglExact.selectedProperty().unbindBidirectional(this.mediaDataDto.cleaningExact);
        this.tglClean.selectedProperty().unbindBidirectional(this.mediaDataDto.cleaning);
        this.tglAndOr.selectedProperty().unbindBidirectional(this.mediaDataDto.cleaningAndOr);
        this.tglList.selectedProperty().unbindBidirectional(this.mediaDataDto.cleaningList);
    }

    public AnchorPane makePane() {
        VBox vBox = new VBox(10.0);
        vBox.setPadding(new Insets(10.0));
        this.initPane();
        this.addGrid(vBox);
        AnchorPane anchorPane = new AnchorPane();
        AnchorPane.setTopAnchor(vBox, 0.0);
        AnchorPane.setRightAnchor(vBox, 0.0);
        AnchorPane.setBottomAnchor(vBox, 0.0);
        AnchorPane.setLeftAnchor(vBox, 0.0);
        anchorPane.getChildren().add(vBox);
        return anchorPane;
    }

    private void initPane() {
        this.tglExact.selectedProperty().bindBidirectional(this.mediaDataDto.cleaningExact);
        this.tglClean.disableProperty().bind(this.tglExact.selectedProperty());
        this.tglClean.selectedProperty().bindBidirectional(this.mediaDataDto.cleaning);
        this.tglAndOr.disableProperty().bind(this.tglExact.selectedProperty().or(this.tglClean.selectedProperty().not()));
        this.tglAndOr.selectedProperty().bindBidirectional(this.mediaDataDto.cleaningAndOr);
        this.tglList.disableProperty().bind(this.tglExact.selectedProperty().or(this.tglClean.selectedProperty().not()));
        this.tglList.selectedProperty().bindBidirectional(this.mediaDataDto.cleaningList);
    }

    private void addGrid(VBox vBox) {
        int row = 0;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
        if (this.mediaDataDto.whatToShow == MediaDataDto.SHOW_WHAT.SHOW_MEDIA) {
            Text text = new Text("Suche in der ");
            text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            text.getStyleClass().add("downloadGuiMediaText");
            Text txtMed = new Text("Mediensammlung");
            txtMed.setUnderline(true);
            txtMed.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            txtMed.getStyleClass().add("downloadGuiMediaText");
            HBox h = new HBox(0.0);
            h.getChildren().addAll((Node[])new Node[]{text, txtMed});
            gridPane.add(h, 0, row);
        } else {
            Text text = new Text("Suche in den ");
            text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            text.getStyleClass().add("downloadGuiMediaText");
            Text txtAbo = new Text("Abos und der History");
            txtAbo.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            txtAbo.getStyleClass().add("downloadGuiMediaText");
            txtAbo.setUnderline(true);
            HBox h = new HBox(0.0);
            h.getChildren().addAll((Node[])new Node[]{text, txtAbo});
            gridPane.add(h, 0, row);
        }
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(this.tglExact, 0, ++row);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(this.tglClean, 0, ++row);
        ++row;
        gridPane.add(this.tglList, 0, ++row);
        gridPane.add(this.tglAndOr, 0, ++row);
    }
}

