/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.mediacleaningdialog;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.gui.dialog.propose.PaneCleaningList;
import de.p2tools.mtplayer.gui.mediaSearch.MediaDataDto;
import de.p2tools.mtplayer.gui.mediacleaningdialog.PaneCleaningConfigController;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class MediaCleaningDialogController
extends P2DialogExtra {
    private final TabPane tabPane = new TabPane();
    private final Button btnOk = new Button("_Ok");
    private final ProgData progData = ProgData.getInstance();
    private PaneCleaningConfigController paneCleaningConfigControllerMedia;
    private PaneCleaningConfigController paneCleaningConfigControllerAbo;
    private PaneCleaningList paneCleaningList;
    private final MediaDataDto mediaDataDtoMedia;
    private final MediaDataDto mediaDataDtoAbo;

    public MediaCleaningDialogController(MediaDataDto mediaDataDtoMedia, MediaDataDto mediaDataDtoAbo) {
        super(ProgData.getInstance().primaryStage, ProgConfig.GUI_MEDIA_CONFIG_DIALOG_SIZE, "Einstellungen", true, false, P2DialogExtra.DECO.NO_BORDER);
        this.mediaDataDtoMedia = mediaDataDtoMedia;
        this.mediaDataDtoAbo = mediaDataDtoAbo;
        this.init(true);
    }

    @Override
    public void make() {
        VBox.setVgrow(this.tabPane, Priority.ALWAYS);
        Button btnHelp = P2Button.helpButton(this.getStage(), "Medien", "Zum Suchen in der Mediensammlung oder den geladenen Abos kann der Suchtext aufbereitet werden.\n\nZuerst kann ausgew\u00e4hlt werden, WIE der Suchtext gebaut wird. Die Auswahl ist: Der Suchtext ist der *Titel* das *Thema* oder *Thema und Titel* des Films.\n\nDann wird angegeben, WO der Suchtext vorkommen muss, also wo der Suchtext gesucht wird.\nHier steht in der Mediensammlung der *Dateiname* und/oder der *Pfad* zur Auswahl. \nBei den Abos kann der Suchtext im *Titel* und/oder *Thema* des Abo-Films gesucht werden.\n\n* Exakt den Begriff suchen *\nDann wird exakt der Suchtext zum Suchen verwendet, er wird dazu in \" eingeschlossen.\n\n* Putzen *\nHier wird der Suchtext aufbereitet, ansonsten wird er direkt zum Suchen verwendet. Aufbereiten meint, dass Zeichen wie \"[\" oder das Datum, ... entfernt werden.\n\n* Cleaning Liste anwenden *\nDie Zeichen/W\u00f6rter die in der Cleaning Liste stehen, werden aus dem Suchtext entfernt. Damit k\u00f6nnen viele \"F\u00fcllw\u00f6rter\" aus dem Suchtext gel\u00f6scht werden um dadurch das Suchergebnis zu verbessern.\n\n* Verkn\u00fcpfen mit UND *\nMit \"UND\" m\u00fcssen die einzelnen W\u00f6rter im Suchtext ALLE im gesuchten Film vorkommen, ansonsten (ODER) muss nur eines davon vorkommen.\n\nDie Cleaning-Liste enth\u00e4lt Zeichen und W\u00f6rter die entfernt werden sollen. \"Immer\" bedeutet, dass das Zeichen immer aus dem Suchtext gel\u00f6scht wird. Ist \"Immer\" nicht eingeschaltet, wird das Wort nur entfernt, wenn es im Suchtext \"frei\" steht. \n\nEin Beispiel-Suchtext: \"ZDF und der ZDF-Comedy Sommer.\"\nIn der Cleaning-Liste sind diese beiden Eintr\u00e4ge: \".\" (Immer ist eingeschaltet) und \"ZDF\" (Immer ist ausgeschaltet). \nJeder \".\" wird entfernt (\"Immer\"). Das erste \"ZDF\" wird hier entfernt, da es frei steht, das zweite nicht (\"Immer\" ist ausgeschaltet).\n\nBeim Entfernen von Teilen des Suchtextes wird der entfernte Text durch ein Leerzeichen ersetzt. So kann dann der restliche Teil des Suchtextes gut mit ',' oder ':' zusammengesetzt werden (Suche mit UND oder ODER).\n");
        this.btnOk.setOnAction(a -> this.close());
        this.addOkButton(this.btnOk);
        this.addHlpButton(btnHelp);
        this.getVBoxCont().setPadding(new Insets(0.0));
        this.getVBoxCont().getChildren().add(this.tabPane);
        this.initPanel();
    }

    @Override
    public void close() {
        this.paneCleaningConfigControllerMedia.close();
        this.paneCleaningConfigControllerAbo.close();
        this.paneCleaningList.close();
        super.close();
    }

    private void initPanel() {
        try {
            this.paneCleaningConfigControllerMedia = new PaneCleaningConfigController(this.getStage(), this.mediaDataDtoMedia);
            Tab tabConfig = new Tab("Einstellungen Mediensammlung");
            tabConfig.setClosable(false);
            tabConfig.setContent(this.paneCleaningConfigControllerMedia.makePane());
            this.tabPane.getTabs().add(tabConfig);
            this.paneCleaningConfigControllerAbo = new PaneCleaningConfigController(this.getStage(), this.mediaDataDtoAbo);
            tabConfig = new Tab("Einstellungen Abos");
            tabConfig.setClosable(false);
            tabConfig.setContent(this.paneCleaningConfigControllerAbo.makePane());
            this.tabPane.getTabs().add(tabConfig);
            this.paneCleaningList = new PaneCleaningList(this.getStage(), false);
            Tab tabCleaningList = new Tab("Cleaning Liste");
            tabCleaningList.setClosable(false);
            tabCleaningList.setContent(this.paneCleaningList.makePane());
            this.tabPane.getTabs().add(tabCleaningList);
        }
        catch (Exception ex) {
            P2Log.errorLog(962104652, ex);
        }
    }
}

