/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.infoPane;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.p2event.P2Listener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class PaneAboInfoList
extends VBox {
    private final VBox vBoxHeader = new VBox();
    private final GridPane gridPane = new GridPane();
    private final ProgData progData = ProgData.getInstance();

    public PaneAboInfoList() {
        VBox.setVgrow(this, Priority.ALWAYS);
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        this.gridPane.getStyleClass().add("downloadInfoGrid");
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSizeRight(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        VBox vBoxAll = new VBox();
        vBoxAll.setSpacing(10.0);
        vBoxAll.setPadding(new Insets(10.0));
        vBoxAll.getChildren().addAll((Node[])new Node[]{this.vBoxHeader, this.gridPane});
        this.getChildren().add(vBoxAll);
        VBox.setVgrow(this.gridPane, Priority.ALWAYS);
        this.progData.aboList.listChangedProperty().addListener((u, o, n) -> this.setInfoText());
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_ABO_HIT_CHANGED){

            @Override
            public void pingGui() {
                PaneAboInfoList.this.setInfoText();
            }
        });
        this.setInfoText();
    }

    public void setInfoText() {
        this.vBoxHeader.getChildren().clear();
        this.gridPane.getChildren().clear();
        if (this.progData.aboList.isEmpty()) {
            Text text1 = new Text("Keine Abos");
            text1.setFont(Font.font(null, FontWeight.BOLD, -1.0));
            text1.getStyleClass().add("downloadGuiMediaText");
            this.vBoxHeader.getChildren().add(text1);
            this.gridPane.setVisible(false);
            return;
        }
        int aboActive = 0;
        int aboInactive = 0;
        int aboActiveHits = 0;
        int aboCountNoHits = 0;
        for (AboData aboData : ProgData.getInstance().aboList) {
            if (aboData.isActive()) {
                ++aboActive;
                aboActiveHits += aboData.getHit();
                if (aboData.getHit() != 0) continue;
                ++aboCountNoHits;
                continue;
            }
            ++aboInactive;
        }
        this.gridPane.setVisible(true);
        int row = 0;
        Text text = new Text("Aktive Abos:");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text, 0, row);
        this.gridPane.add(new Label("" + aboActive), 1, row);
        this.gridPane.add(new Label(" "), 2, row);
        text = new Text("Treffer:");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(new Label("( Treffer:"), 3, row);
        this.gridPane.add(new Label(aboActiveHits + " )"), 4, row);
        ++row;
        text = new Text("Aktive Abos ohne Treffer:");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text, 0, ++row);
        this.gridPane.add(new Label("" + aboCountNoHits), 1, row);
        ++row;
        text = new Text("Inaktive Abos:");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.getStyleClass().add("downloadGuiMediaText");
        this.gridPane.add(text, 0, ++row);
        this.gridPane.add(new Label("" + aboInactive), 1, row);
    }
}

