/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.live;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.LiveSearchZdf;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveFactory;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class LiveFilterTabZdf
extends Tab {
    private final ProgData progData;
    private final JsonInfoDto jsonInfoDto = new JsonInfoDto();
    private final ProgressBar progress = new ProgressBar();
    private final VBox vBoxTab = new VBox();

    public LiveFilterTabZdf() {
        super("ZDF");
        this.progData = ProgData.getInstance();
        this.setClosable(false);
        ProgConfig.LIVE_FILM_GUI_SEARCH_ZDF.addListener((u, o, n) -> this.jsonInfoDto.init());
        this.addTabZdf();
        this.addProgress();
    }

    private void addTabZdf() {
        this.vBoxTab.setSpacing(10.0);
        this.vBoxTab.setPadding(new Insets(10.0));
        this.vBoxTab.setAlignment(Pos.TOP_CENTER);
        Button btnClear = new Button();
        btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnClear.setTooltip(new Tooltip("Suche l\u00f6schen"));
        btnClear.setOnAction(a -> ProgConfig.LIVE_FILM_GUI_SEARCH_ZDF.set(""));
        PCboString cboSearch = new PCboString(this.progData.stringFilterLists.getFilterListZdfLive(), ProgConfig.LIVE_FILM_GUI_SEARCH_ZDF);
        Button btnSearchZdf = new Button();
        btnSearchZdf.setGraphic(ProgIcons.ICON_BUTTON_SEARCH.getImageView());
        btnSearchZdf.setTooltip(new Tooltip("Suche starten"));
        btnSearchZdf.setOnAction(a -> this.searchZdf(false));
        btnSearchZdf.disableProperty().bind(ProgConfig.LIVE_FILM_GUI_SEARCH_ZDF.length().lessThan(4).or(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ZDF).isNotEqualTo(LiveFactory.PROGRESS_NULL)));
        Button btnKeepOnZdf = new Button("Weitersuchen");
        btnKeepOnZdf.setGraphic(ProgIcons.ICON_BUTTON_FORWARD.getImageView());
        btnKeepOnZdf.setTooltip(new Tooltip("Weitersuchen"));
        btnKeepOnZdf.setOnAction(a -> this.searchZdf(true));
        btnKeepOnZdf.disableProperty().bind(this.jsonInfoDto.zdfNextCursorProperty().isEmpty().or(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ZDF).isNotEqualTo(LiveFactory.PROGRESS_NULL)));
        VBox vBox = new VBox();
        vBox.setSpacing(2.0);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{cboSearch, btnClear});
        HBox.setHgrow(cboSearch, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Livesuche ZDF"), hBox});
        hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 0.0, 0.0, 0.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{btnKeepOnZdf, btnSearchZdf});
        vBox.getChildren().add(hBox);
        this.vBoxTab.getChildren().add(vBox);
        Button btnClearUrl = new Button();
        btnClearUrl.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnClearUrl.setTooltip(new Tooltip("Suche l\u00f6schen"));
        btnClearUrl.setOnAction(a -> ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ZDF.set(""));
        Button btnSearchUrlZdf = new Button();
        btnSearchUrlZdf.setGraphic(ProgIcons.ICON_BUTTON_SEARCH.getImageView());
        btnSearchUrlZdf.setTooltip(new Tooltip("Suche starten"));
        btnSearchUrlZdf.setOnAction(a -> this.searchUrl());
        btnSearchUrlZdf.disableProperty().bind(ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ZDF.isEmpty().or(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ZDF).isNotEqualTo(LiveFactory.PROGRESS_NULL)));
        PCboString cboSearchUrl = new PCboString(this.progData.stringFilterLists.getFilterListZdfUrl(), ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ZDF);
        vBox = new VBox(2.0);
        hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{cboSearchUrl, btnClearUrl});
        HBox.setHgrow(cboSearchUrl, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("URL ZDF-Filmseite"), hBox});
        hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 0.0, 0.0, 0.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{btnSearchUrlZdf});
        vBox.getChildren().add(hBox);
        this.vBoxTab.getChildren().add(vBox);
        this.setContent(this.vBoxTab);
    }

    private void searchZdf(boolean next) {
        new Thread(() -> new LiveSearchZdf().loadLive(this.jsonInfoDto, next)).start();
    }

    private void searchUrl() {
        new Thread(() -> new LiveSearchZdf().loadUrl(this.jsonInfoDto)).start();
    }

    private void addProgress() {
        this.progress.progressProperty().bind(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ZDF));
        this.progress.visibleProperty().bind(LiveFactory.getProgressProperty(LiveFactory.CHANNEL.ZDF).greaterThan(-1));
        this.progress.setMaxWidth(Double.MAX_VALUE);
        this.vBoxTab.getChildren().addAll((Node[])new Node[]{this.progress});
        VBox.setVgrow(this.progress, Priority.ALWAYS);
    }
}

