/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.helper;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.p2lib.mtfilter.FilterCheckRegEx;
import java.util.function.BooleanSupplier;
import javafx.beans.property.StringProperty;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;

public class PCboString_
extends ComboBox<PCboSearchLabel> {
    public static final int MAX_FILTER_HISTORY = 15;
    private final StringProperty strSearchProperty;
    private final BooleanSupplier actFilter;

    public PCboString_(StringProperty strSearchProperty, BooleanSupplier actFilter) {
        this.strSearchProperty = strSearchProperty;
        this.actFilter = actFilter;
        this.setEditable(true);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setVisibleRowCount(15);
        for (int i = 0; i < 15; ++i) {
            this.getItems().add(new PCboSearchLabel());
        }
        this.init();
    }

    private void init() {
        FilterCheckRegEx regEx = new FilterCheckRegEx(this.getEditor());
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (!this.isShowing()) {
                this.addLastFilter();
            }
            regEx.checkPattern();
            this.strSearchProperty.setValue(this.getEditor().getText());
        });
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue() && (this.isShowing() || newValue != null && newValue.getClass().equals(PCboSearchLabel.class) && !this.strSearchProperty.getValueSafe().equals(((PCboSearchLabel)newValue).getText()))) {
                this.actFilter.getAsBoolean();
            }
        });
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.actFilter.getAsBoolean();
            }
        });
        this.strSearchProperty.addListener((u, o, n) -> this.getEditor().setText(this.strSearchProperty.getValue()));
        this.getEditor().setText(this.strSearchProperty.getValue());
    }

    private synchronized void addLastFilter() {
        String filterStr = this.getEditor().getText();
        if (filterStr == null || filterStr.isEmpty()) {
            return;
        }
        PCboSearchLabel tmp = (PCboSearchLabel)this.getItems().get(1);
        if (filterStr.contains(tmp.getText())) {
            tmp.setText(filterStr);
            return;
        }
        for (int i = this.getItems().size() - 2; i >= 1; --i) {
            ((PCboSearchLabel)this.getItems().get(i + 1)).setText(((PCboSearchLabel)this.getItems().get(i)).getText());
        }
        ((PCboSearchLabel)this.getItems().get(1)).setText(filterStr);
    }

    static class PCboSearchLabel
    extends Label
    implements Comparable<PCboSearchLabel> {
        public PCboSearchLabel() {
        }

        public PCboSearchLabel(String value) {
            this.setText(value);
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        public int compareTo(PCboSearchLabel arg0) {
            return this.getText().compareTo(arg0.getText());
        }
    }
}

