/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter.helper;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.p2lib.mtfilter.FilterCheckRegEx;
import java.util.function.BooleanSupplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;

public class PCboString
extends ComboBox<PCboLabel> {
    public static final int MAX_FILTER_HISTORY = 15;
    private final ObservableList<String> storedFilterList;
    private final ObservableList<PCboLabel> itemList = FXCollections.observableArrayList(new PCboLabel(""));
    private final StringProperty strSearchProperty;
    private final BooleanSupplier doSomething;

    public PCboString(ObservableList<String> storedFilterList, StringProperty strSearchProperty) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = () -> true;
        this.start();
    }

    public PCboString(ObservableList<String> storedFilterList, StringProperty strSearchProperty, BooleanSupplier doSomething) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = doSomething;
        this.start();
    }

    private void start() {
        this.storedFilterList.forEach(s -> {
            PCboLabel tf;
            if (!s.isEmpty() && (tf = (PCboLabel)this.itemList.stream().filter(pCboSearchLabel -> pCboSearchLabel.getText().equals(s)).findFirst().orElse(null)) == null) {
                this.itemList.add(new PCboLabel((String)s));
            }
        });
        this.setItems(this.itemList);
        this.fillStoredList();
        this.setEditable(true);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setVisibleRowCount(15);
        this.init();
    }

    private void init() {
        FilterCheckRegEx regEx = new FilterCheckRegEx(this.getEditor());
        regEx.checkPattern();
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (!this.isShowing()) {
                this.addLastFilter((String)newValue);
            }
            this.strSearchProperty.setValue(this.getEditor().getText());
        });
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue() && (this.isShowing() || newValue != null && newValue.getClass().equals(PCboLabel.class) && !this.strSearchProperty.getValueSafe().equals(((PCboLabel)newValue).getText()))) {
                this.doSomething.getAsBoolean();
            }
        });
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.doSomething.getAsBoolean();
            }
        });
        this.strSearchProperty.addListener((u, o, n) -> this.getEditor().setText(this.strSearchProperty.getValue()));
        this.getEditor().setText(this.strSearchProperty.getValue());
        this.setCellFactory(cell -> new ListCell<PCboLabel>(){
            final Button btnDel = new Button();
            final HBox hBox = new HBox();
            final Label lblFilter = new Label();
            {
                this.btnDel.setGraphic(ProgIcons.ICON_BUTTON_DEL_SW.getImageView());
                this.btnDel.getStyleClass().add("buttonVerySmall");
                this.btnDel.visibleProperty().bind(Bindings.size(PCboString.this.itemList).greaterThan(1));
                this.hBox.setPadding(new Insets(0.0));
                this.hBox.setAlignment(Pos.CENTER_LEFT);
                this.hBox.setSpacing(5.0);
                this.hBox.getChildren().addAll((Node[])new Node[]{this.btnDel, this.lblFilter});
            }

            @Override
            protected void updateItem(PCboLabel searchLabel, boolean empty) {
                super.updateItem(searchLabel, empty);
                PCboString.this.setVisibleRowCount(8);
                PCboString.this.setVisibleRowCount(10);
                if (!empty && searchLabel != null) {
                    this.btnDel.setOnMousePressed(m -> {
                        if (searchLabel.getText().isEmpty()) {
                            if (PCboString.this.itemList.size() > 1) {
                                PCboString.this.itemList.remove(1, PCboString.this.itemList.size());
                            }
                        } else {
                            PCboString.this.itemList.remove(searchLabel);
                        }
                        PCboString.this.getSelectionModel().select(0);
                        PCboString.this.fillStoredList();
                    });
                    this.lblFilter.textProperty().bind(searchLabel.textProperty());
                    this.setGraphic(this.hBox);
                } else {
                    this.setGraphic(null);
                }
            }
        });
    }

    private synchronized void addLastFilter(String addF) {
        PCboLabel tf;
        this.getSelectionModel().clearSelection();
        PCboLabel addFilter = new PCboLabel(addF);
        if (addFilter.getText().isEmpty()) {
            return;
        }
        if (this.getItems().size() <= 1) {
            this.getItems().add(addFilter);
            return;
        }
        PCboLabel tmp = (PCboLabel)this.getItems().get(1);
        if (addF.contains(tmp.getText())) {
            tmp.setText(addF);
        }
        if ((tf = (PCboLabel)this.itemList.stream().filter(pCboSearchLabel -> pCboSearchLabel.getText().equals(addF)).findFirst().orElse(null)) == null) {
            while (this.itemList.size() > 15) {
                this.itemList.remove(this.itemList.size() - 1);
            }
            this.itemList.add(1, addFilter);
        } else {
            this.itemList.remove(tf);
            this.itemList.add(1, tf);
        }
        this.fillStoredList();
    }

    private void fillStoredList() {
        this.storedFilterList.clear();
        this.itemList.forEach(s -> this.storedFilterList.add(s.toString()));
    }

    static class PCboLabel
    extends Label
    implements Comparable<PCboLabel> {
        public PCboLabel(String value) {
            this.setText(value);
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        public int compareTo(PCboLabel arg0) {
            return this.getText().compareTo(arg0.getText());
        }
    }
}

