/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import java.util.function.BooleanSupplier;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

public class SearchFast
extends HBox {
    private final Button btnSearch = new Button();
    private final Button btnSelectWhere = new Button();
    private final Button btnClear = new Button();
    private final PCboString cboSearch;
    private final Label lblTitel = new Label("");
    private final ProgData progData = ProgData.getInstance();

    public SearchFast() {
        BooleanSupplier booleanSupplier = () -> {
            this.progData.filterWorker.getFastFilterSettings().reportFilterReturn();
            return true;
        };
        this.cboSearch = new PCboString(this.progData.stringFilterLists.getFilterListFastFilter(), this.progData.filterWorker.getFastFilterSettings().filterTermProperty(), booleanSupplier);
        this.make();
    }

    private void make() {
        ProgConfig.FAST_SEARCH_ON.addListener((u, o, n) -> this.setFastSearchOnOff(true));
        ProgConfig.FAST_SEARCH_WHERE.addListener((u, o, n) -> this.setLblText());
        ProgConfig.FILM__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> {
            if (ProgConfig.FILM__FILTER_IS_SHOWING.getValue().booleanValue() && ProgConfig.FAST_SEARCH_ON.getValue().booleanValue()) {
                ProgConfig.FAST_SEARCH_ON.setValue(false);
            }
        });
        this.initText();
        this.initListener();
        this.setLblText();
        this.setFastSearchOnOff(false);
    }

    private void initText() {
        HBox hBoxTitle = new HBox(10.0);
        hBoxTitle.setAlignment(Pos.CENTER_LEFT);
        hBoxTitle.setPadding(new Insets(0.0));
        hBoxTitle.getChildren().addAll((Node[])new Node[]{this.btnSelectWhere, this.lblTitel});
        HBox hBoxCbo = new HBox(5.0);
        hBoxCbo.setAlignment(Pos.CENTER_RIGHT);
        hBoxCbo.setPadding(new Insets(0.0));
        hBoxCbo.getChildren().addAll((Node[])new Node[]{this.cboSearch, this.btnClear});
        HBox.setHgrow(this.cboSearch, Priority.ALWAYS);
        VBox vBox = new VBox(3.0);
        vBox.setAlignment(Pos.CENTER_LEFT);
        vBox.setPadding(new Insets(0.0));
        vBox.getChildren().addAll((Node[])new Node[]{hBoxTitle, hBoxCbo});
        vBox.visibleProperty().bind(ProgConfig.FAST_SEARCH_ON);
        HBox.setHgrow(vBox, Priority.ALWAYS);
        this.btnSearch.setGraphic(ProgIcons.ICON_TOOLBAR_BUTTON_SEARCH.getImageView());
        this.btnSearch.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-1"});
        this.btnSelectWhere.setGraphic(ProgIcons.ICON_BUTTON_UP_DOWN_H.getImageView());
        this.btnSelectWhere.getStyleClass().addAll((String[])new String[]{"selectButton"});
        this.btnClear.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.lblTitel.setFont(new Font(10.0));
        this.setAlignment(Pos.CENTER_RIGHT);
        this.setPadding(new Insets(1.0, 10.0, 1.0, 2.0));
        this.setSpacing(10.0);
        this.getChildren().addAll((Node[])new Node[]{vBox, this.btnSearch});
    }

    private void initListener() {
        this.btnSearch.setOnMouseClicked(mouseEvent -> {
            ProgConfig.FAST_SEARCH_ON.setValue(ProgConfig.FAST_SEARCH_ON.getValue() == false);
            ProgConfig.FILM__FILTER_IS_SHOWING.setValue(ProgConfig.FAST_SEARCH_ON.getValue() == false);
        });
        this.btnSelectWhere.setOnMouseClicked(event -> {
            if (ProgConfig.FAST_SEARCH_WHERE.getValue() == 2) {
                ProgConfig.FAST_SEARCH_WHERE.setValue(0);
            } else {
                ProgConfig.FAST_SEARCH_WHERE.setValue(1 + ProgConfig.FAST_SEARCH_WHERE.getValue());
            }
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED);
        });
        this.btnClear.setOnAction(a -> this.progData.filterWorker.getFastFilterSettings().clearFilter());
    }

    private void setFastSearchOnOff(boolean andSearch) {
        if (ProgConfig.FAST_SEARCH_ON.getValue().booleanValue()) {
            this.setMaxWidth(500.0);
            this.getStyleClass().remove("fast-search-off");
            this.getStyleClass().add("fast-search-on");
        } else {
            this.setMaxWidth(50.0);
            this.getStyleClass().remove("fast-search-on");
            this.getStyleClass().add("fast-search-off");
        }
        if (andSearch) {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_CHANGED);
        }
    }

    private void setLblText() {
        if (ProgConfig.FAST_SEARCH_WHERE.getValue() == 0) {
            this.lblTitel.setText("Thema oder Titel");
        } else if (ProgConfig.FAST_SEARCH_WHERE.getValue() == 1) {
            this.lblTitel.setText("Thema");
        } else {
            this.lblTitel.setText("Titel");
        }
    }
}

