/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2SeparatorComboBox;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class FilmFilterSortDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnUp = new Button();
    private final Button btnDown = new Button();
    private final Button btnTop = new Button();
    private final Button btnBottom = new Button();
    private final Button btnDel = new Button();
    private final Button btnAddSeparator = new Button();
    private final TableView<FilmFilter> tableView = new TableView();
    private final ProgData progData;

    public FilmFilterSortDialog(ProgData progData) {
        super(ProgData.getInstance().primaryStage, null, "Filmfilter", true, true, P2DialogExtra.DECO.NO_BORDER);
        this.progData = progData;
        this.init(false);
    }

    @Override
    public void make() {
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
        VBox vBox = new VBox(10.0);
        vBox.setAlignment(Pos.TOP_CENTER);
        vBox.getChildren().addAll((Node[])new Node[]{this.btnTop, this.btnUp, this.btnDown, this.btnBottom, this.btnDel, this.btnAddSeparator});
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.tableView, vBox});
        HBox.setHgrow(this.tableView, Priority.ALWAYS);
        VBox.setVgrow(hBox, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(hBox);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setMinHeight(200.0);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn<FilmFilter, String> nameColumn = new TableColumn<FilmFilter, String>("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        this.columnFactoryString(nameColumn);
        this.tableView.getColumns().add(nameColumn);
        this.tableView.setItems(this.progData.filterWorker.getFilmFilterList());
        this.btnDel.setTooltip(new Tooltip("aktuelles Filterprofil l\u00f6schen"));
        this.btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        this.btnDel.setOnAction(e -> this.delFilter());
        this.btnAddSeparator.setTooltip(new Tooltip("einen Trenner einf\u00fcgen"));
        this.btnAddSeparator.setGraphic(ProgIcons.ICON_BUTTON_SEPARATOR.getImageView());
        this.btnAddSeparator.setOnAction(e -> this.addSeparator());
        this.btnTop.setTooltip(new Tooltip("aktuelles Filterprofil an den Anfang verschieben"));
        this.btnTop.setGraphic(ProgIcons.ICON_BUTTON_MOVE_TOP.getImageView());
        this.btnTop.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection();
            } else {
                int res = this.progData.filterWorker.getFilmFilterList().top(sel, true);
                this.tableView.getSelectionModel().select(res);
            }
        });
        this.btnBottom.setTooltip(new Tooltip("aktuelles Filterprofil an das Ende verschieben"));
        this.btnBottom.setGraphic(ProgIcons.ICON_BUTTON_MOVE_BOTTOM.getImageView());
        this.btnBottom.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection();
            } else {
                int res = this.progData.filterWorker.getFilmFilterList().top(sel, false);
                this.tableView.getSelectionModel().select(res);
            }
        });
        this.btnUp.setTooltip(new Tooltip("aktuelles Filterprofil nach oben verschieben"));
        this.btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        this.btnUp.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection();
            } else {
                int res = this.progData.filterWorker.getFilmFilterList().up(sel, true);
                this.tableView.getSelectionModel().select(res);
            }
        });
        this.btnDown.setTooltip(new Tooltip("aktuelles Filterprofil nach unten verschieben"));
        this.btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        this.btnDown.setOnAction(event -> {
            int sel = this.tableView.getSelectionModel().getSelectedIndex();
            if (sel < 0) {
                P2Alert.showInfoNoSelection();
            } else {
                int res = this.progData.filterWorker.getFilmFilterList().up(sel, false);
                this.tableView.getSelectionModel().select(res);
            }
        });
    }

    private void delFilter() {
        FilmFilter sf = (FilmFilter)this.tableView.getSelectionModel().getSelectedItem();
        if (sf == null) {
            P2Alert.showInfoNoSelection();
            return;
        }
        if (this.progData.filterWorker.getFilmFilterList().removeStoredFilter(sf)) {
            this.tableView.getSelectionModel().selectFirst();
        }
    }

    private void addSeparator() {
        int sel = this.tableView.getSelectionModel().getSelectedIndex();
        FilmFilter sf = new FilmFilter("=====<>=====");
        if (sel < 0) {
            this.progData.filterWorker.getFilmFilterList().add(sf);
        } else {
            this.progData.filterWorker.getFilmFilterList().add(sel + 1, sf);
        }
    }

    private void columnFactoryString(TableColumn<FilmFilter, String> column) {
        column.setCellFactory(c -> new TableCell<FilmFilter, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                if (P2SeparatorComboBox.isSeparator(item)) {
                    this.setGraphic(ProgIcons.ICON_BUTTON_SEPARATOR_WIDTH.getImageView());
                    this.setText(null);
                    this.setStyle("-fx-alignment: center;");
                } else {
                    this.setGraphic(null);
                    this.setText(item);
                    this.setStyle("");
                }
            }
        });
    }
}

