/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class FilmFilterEditDialog
extends P2DialogExtra {
    private final ProgData progData;
    private final RadioButton rbLast = new RadioButton("Die letzte vorhandene Zeile ausw\u00e4hlen");
    private final RadioButton rbFirst = new RadioButton("Die erste Tabellenzeile ausw\u00e4hlen");
    private final RadioButton rbNothing = new RadioButton("Nichts neues ausw\u00e4hlen");

    public FilmFilterEditDialog(ProgData progData) {
        super(progData.primaryStage, null, "Filtereinstellungen", true, false, P2DialogExtra.DECO.NO_BORDER);
        this.progData = progData;
        this.init(true);
    }

    @Override
    public void close() {
        this.rbFirst.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_FILTER_FIRST_ROW);
        this.rbNothing.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_FILTER_NONE_ROW);
        super.close();
    }

    @Override
    public void make() {
        this.init();
        Button btnHelp = P2Button.helpButton(this.getStage(), "Filtereinstellungen", "=============\nFilter\nHier k\u00f6nnen Filter aktiviert und deaktiviert werden. Deaktivierte Filter werden beim Suchen der Filme nicht ber\u00fccksichtigt, daher ist eine Suche mit weniger Filtern schneller.\n\n=============\nEinstellungen\nSuchbeginn verz\u00f6gern:\nHier kann eine Zeit eingestellt werden, die den Start der Suche verz\u00f6gert. Gibt man einen Suchbegriff ein, wird nicht sofort nach jedem eingegebenen Buchstaben, die Suche gestartet.\n\nReturn:\nDiese Einstellung startet die Suche in den Textfeldern erst nach Eingabe der Return-Taste.\n\nIn den Textfeldern wird die Suche immer sofort nach Eingabe der Return-Taste gestartet. Mit der Einstellung \"Return\" aber ausschlie\u00dflich.\n\nIch kann eine Suche also starten wenn ich ein Suchfeld (egal welches) \u00e4ndere und die Wartezeit abwarte. In einem Textfeld (egal welchem) kann ich zus\u00e4tzlich die Suche starten wenn ich \"Return\" klicke.\n\nAuswahl der Tabellenzeile:\nNach einer Suche ist ja eine andere Auswahl an Filmen in der Filmliste. \n\"Die erste Tabellenzeile:\" Hier wird dann immer die erste Zeile ausgew\u00e4hlt\n\"Letzte vorhandene Zeile:\" Damit wird die erste noch vorhandene Tabellenzeile ausgew\u00e4hlt die vor der, vorher ausgew\u00e4hlten Zeile liegt.\n\"Nichts ausw\u00e4hlen:\" Das macht genau das, in der Filmtabelle wird nichts ausgew\u00e4hlt.");
        Button btnOk = new Button("_Ok");
        btnOk.setOnAction(event -> this.close());
        this.addOkButton(btnOk);
        this.addHlpButton(btnHelp);
    }

    public void init() {
        TabPane tabPane = new TabPane();
        VBox vBox = this.getVBoxCont();
        vBox.getChildren().add(tabPane);
        VBox.setVgrow(tabPane, Priority.ALWAYS);
        this.addFilterTab(tabPane);
        this.addConfigTab(tabPane);
    }

    public void addFilterTab(TabPane tabPane) {
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        vBox.setSpacing(15.0);
        Tab tab = new Tab();
        tab.setText("Filter");
        tab.setClosable(false);
        tab.setContent(vBox);
        tabPane.getTabs().add(tab);
        P2ToggleSwitch tglChannel = new P2ToggleSwitch("Sender");
        tglChannel.setMaxWidth(Double.MAX_VALUE);
        tglChannel.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().channelVisProperty());
        vBox.getChildren().add(tglChannel);
        P2ToggleSwitch tglTheme = new P2ToggleSwitch("Thema");
        tglTheme.setMaxWidth(Double.MAX_VALUE);
        tglTheme.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().themeVisProperty());
        P2ToggleSwitch tglThemeExact = new P2ToggleSwitch("  -> Freie Suche mit Eingabefeld");
        tglThemeExact.disableProperty().bind(this.progData.filterWorker.getActFilterSettings().themeVisProperty().not());
        tglThemeExact.setMaxWidth(Double.MAX_VALUE);
        tglThemeExact.setSelected(!this.progData.filterWorker.getActFilterSettings().isThemeIsExact());
        tglThemeExact.selectedProperty().addListener((observable2, oldValue, newValue) -> this.progData.filterWorker.getActFilterSettings().themeIsExactProperty().setValue(newValue == false));
        VBox v = new VBox(5.0);
        HBox h = new HBox(0.0);
        h.setPadding(new Insets(0.0, 15.0, 0.0, 5.0));
        h.getChildren().add(tglThemeExact);
        HBox.setHgrow(tglThemeExact, Priority.ALWAYS);
        v.getChildren().addAll((Node[])new Node[]{tglTheme, h});
        vBox.getChildren().add(v);
        P2ToggleSwitch tglThemeTitle = new P2ToggleSwitch("Thema oder Titel");
        tglThemeTitle.setMaxWidth(Double.MAX_VALUE);
        tglThemeTitle.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().themeTitleVisProperty());
        vBox.getChildren().add(tglThemeTitle);
        P2ToggleSwitch tglTitle = new P2ToggleSwitch("Titel");
        tglTitle.setMaxWidth(Double.MAX_VALUE);
        tglTitle.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().titleVisProperty());
        vBox.getChildren().add(tglTitle);
        P2ToggleSwitch tglSomewhere = new P2ToggleSwitch("Irgendwo");
        tglSomewhere.setMaxWidth(Double.MAX_VALUE);
        tglSomewhere.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().somewhereVisProperty());
        vBox.getChildren().add(tglSomewhere);
        P2ToggleSwitch tglUrl = new P2ToggleSwitch("Url");
        tglUrl.setMaxWidth(Double.MAX_VALUE);
        tglUrl.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().urlVisProperty());
        vBox.getChildren().add(tglUrl);
        P2ToggleSwitch tglTimeRange = new P2ToggleSwitch("Zeitraum [Tage]");
        tglTimeRange.setMaxWidth(Double.MAX_VALUE);
        tglTimeRange.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().timeRangeVisProperty());
        vBox.getChildren().add(tglTimeRange);
        P2ToggleSwitch tglMinMax = new P2ToggleSwitch("Filml\u00e4nge Min/Max");
        tglMinMax.setMaxWidth(Double.MAX_VALUE);
        tglMinMax.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().minMaxDurVisProperty());
        vBox.getChildren().add(tglMinMax);
        P2ToggleSwitch tglMinMaxTime = new P2ToggleSwitch("Sendezeit");
        tglMinMaxTime.setMaxWidth(Double.MAX_VALUE);
        tglMinMaxTime.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().minMaxTimeVisProperty());
        vBox.getChildren().add(tglMinMaxTime);
        P2ToggleSwitch tglShowDate = new P2ToggleSwitch("Sendedatum");
        tglShowDate.setMaxWidth(Double.MAX_VALUE);
        tglShowDate.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().showDateVisProperty());
        vBox.getChildren().add(tglShowDate);
        P2ToggleSwitch tglOnly = new P2ToggleSwitch("\"Anzeigen\"");
        tglOnly.setMaxWidth(Double.MAX_VALUE);
        tglOnly.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().onlyVisProperty());
        vBox.getChildren().add(tglOnly);
        P2ToggleSwitch tglNot = new P2ToggleSwitch("\"Ausschlie\u00dfen\"");
        tglNot.setMaxWidth(Double.MAX_VALUE);
        tglNot.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().notVisProperty());
        vBox.getChildren().add(tglNot);
    }

    public void addConfigTab(TabPane tabPane) {
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        vBox.setSpacing(15.0);
        Tab tab = new Tab();
        tab.setText("Einstellungen");
        tab.setClosable(false);
        tab.setContent(vBox);
        tabPane.getTabs().add(tab);
        P2ToggleSwitch tglReturn = new P2ToggleSwitch("In Textfeldern Suchbeginn erst mit \"Return\" starten");
        tglReturn.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILTER_RETURN);
        Label lblValue = new Label();
        lblValue.setMinWidth(-1.0);
        Slider slider = new Slider();
        slider.setMin(0.0);
        slider.setMax(2000.0);
        slider.setMinorTickCount(4);
        slider.setBlockIncrement(200.0);
        slider.setMajorTickUnit(500.0);
        slider.setShowTickMarks(true);
        slider.setShowTickLabels(true);
        slider.setSnapToTicks(true);
        slider.valueProperty().addListener((observable2, oldValue, newValue) -> {
            ProgConfig.SYSTEM_FILTER_WAIT_TIME.setValue(Double.valueOf(slider.getValue()).intValue());
            this.setLabel(lblValue);
        });
        slider.setValue(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue());
        this.setLabel(lblValue);
        slider.disableProperty().bind(tglReturn.selectedProperty());
        lblValue.disableProperty().bind(tglReturn.selectedProperty());
        this.rbLast.setTooltip(new Tooltip("Nach einer Suche, sind nicht mehr die gleichen\nFilme in der Tabelle. Hier kann vorgegeben werden,\nwelche Zeile dann ausgew\u00e4hlt werden soll."));
        this.rbFirst.setTooltip(new Tooltip("Nach einer Suche, sind nicht mehr die gleichen\nFilme in der Tabelle. Hier kann vorgegeben werden,\nwelche Zeile dann ausgew\u00e4hlt werden soll."));
        this.rbNothing.setTooltip(new Tooltip("Nach einer Suche, sind nicht mehr die gleichen\nFilme in der Tabelle. Hier kann vorgegeben werden,\nwelche Zeile dann ausgew\u00e4hlt werden soll."));
        ToggleGroup tg = new ToggleGroup();
        this.rbLast.setToggleGroup(tg);
        this.rbFirst.setToggleGroup(tg);
        this.rbNothing.setToggleGroup(tg);
        this.rbFirst.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILTER_FIRST_ROW);
        this.rbNothing.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FILTER_NONE_ROW);
        if (!ProgConfig.SYSTEM_FILTER_FIRST_ROW.get() && !ProgConfig.SYSTEM_FILTER_NONE_ROW.get()) {
            this.rbLast.setSelected(true);
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(0.0));
        gridPane.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow(gridPane, Priority.ALWAYS);
        int row = 0;
        gridPane.add(new Label("Suchbeginn nach Eingabe verz\u00f6gern:"), 0, row);
        gridPane.add(lblValue, 1, row);
        GridPane.setHalignment(lblValue, HPos.RIGHT);
        gridPane.add(slider, 0, ++row, 2, 1);
        GridPane.setHgrow(slider, Priority.ALWAYS);
        slider.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        gridPane.add(new Label(), 0, ++row, 2, 1);
        gridPane.add(tglReturn, 0, ++row, 2, 1);
        gridPane.add(new Label(""), 0, ++row, 2, 1);
        gridPane.add(new Label(""), 0, ++row, 2, 1);
        gridPane.add(new Label("Welche Zeile soll nach einer Suche ausgew\u00e4hlt werden:"), 0, ++row, 2, 1);
        gridPane.add(this.rbFirst, 0, ++row, 2, 1);
        gridPane.add(this.rbLast, 0, ++row, 2, 1);
        gridPane.add(this.rbNothing, 0, ++row, 2, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrowRight()});
        vBox.getChildren().addAll((Node[])new Node[]{gridPane});
    }

    private int setLabel(Label lblValue) {
        int intValue = ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue();
        lblValue.setText("  " + intValue + " ms");
        return intValue;
    }
}

