/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2SeparatorComboBox;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class FilmFilterDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnClearFilter = new Button("Filter l\u00f6schen");
    private final TableView<FilmFilter> tableView = new TableView();
    private final ProgData progData;

    public FilmFilterDialog(ProgData progData) {
        super(ProgData.getInstance().primaryStage, ProgConfig.FILM__FILTER_DIALOG_SIZE, "Filmfilter", false, false, P2DialogExtra.DECO.NO_BORDER, true);
        this.progData = progData;
        this.init(false);
    }

    @Override
    public void make() {
        this.setMaskerPane();
        this.progData.maskerPane.visibleProperty().addListener((u, o, n) -> this.setMaskerPane());
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
        this.addAnyButton(this.btnClearFilter);
        this.btnClearFilter.setTooltip(new Tooltip("Der Filter (nicht das Filterprofil) wird gel\u00f6scht"));
        this.btnClearFilter.setOnAction(a -> {
            this.progData.filterWorker.clearFilter();
            this.tableView.getSelectionModel().clearSelection();
        });
        this.getVBoxCont().getChildren().add(this.tableView);
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setMinHeight(200.0);
        this.tableView.setMaxHeight(Double.MAX_VALUE);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((u, o, n) -> {
            if (n != null) {
                this.progData.filterWorker.setActFilterSettings((FilmFilter)n);
            }
        });
        this.tableView.setRowFactory(param -> new TableRow<FilmFilter>(){

            @Override
            protected void updateItem(FilmFilter item, boolean empty) {
                super.updateItem(item, empty);
                if (!empty) {
                    this.setDisable(P2SeparatorComboBox.isSeparator(item.toString()));
                }
            }
        });
        TableColumn<FilmFilter, String> nameColumn = new TableColumn<FilmFilter, String>("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        this.columnFactoryString(nameColumn);
        this.tableView.getColumns().add(nameColumn);
        this.tableView.setItems(this.progData.filterWorker.getFilmFilterList());
    }

    @Override
    public void showDialog() {
        ProgConfig.FILM_GUI_FILTER_DIALOG_IS_SHOWING.setValue(true);
        super.showDialog();
    }

    @Override
    public void close() {
        ProgConfig.FILM_GUI_FILTER_DIALOG_IS_SHOWING.setValue(false);
        super.close();
    }

    private void setMaskerPane() {
        if (this.progData.maskerPane.isVisible()) {
            this.setMaskerVisible(true);
        } else {
            this.setMaskerVisible(false);
        }
    }

    private void columnFactoryString(TableColumn<FilmFilter, String> column) {
        column.setCellFactory(c -> new TableCell<FilmFilter, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    this.setStyle("");
                    return;
                }
                if (P2SeparatorComboBox.isSeparator(item.toString())) {
                    this.setGraphic(ProgIcons.ICON_BUTTON_SEPARATOR_WIDTH.getImageView());
                    this.setText(null);
                    this.setStyle("-fx-alignment: center;");
                    this.setDisable(true);
                } else {
                    this.setGraphic(null);
                    this.setText(item.toString());
                    this.setStyle("");
                    this.setDisable(false);
                }
            }
        });
    }
}

