/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.mtplayer.gui.filter.helper.PCboString;
import de.p2tools.mtplayer.gui.filter.helper.PCboThemeExact;
import de.p2tools.p2lib.guitools.P2MenuButton;
import java.util.function.BooleanSupplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.VBox;

public class FilmFilterControllerTextFilter
extends VBox {
    private final P2MenuButton mbChannel;
    private final PCboThemeExact cboThemeExact;
    private final PCboString cboTheme;
    private final PCboString cboThemeTitle;
    private final PCboString cboTitle;
    private final PCboString cboSomewhere;
    private final PCboString cboUrl;
    private final ProgData progData = ProgData.getInstance();

    public FilmFilterControllerTextFilter() {
        this.mbChannel = new P2MenuButton(this.progData.filterWorker.getActFilterSettings().channelProperty(), ThemeListFactory.allChannelList);
        BooleanSupplier supplierReportReturn = () -> {
            this.progData.filterWorker.getActFilterSettings().reportFilterReturn();
            return true;
        };
        this.cboThemeExact = new PCboThemeExact(this.progData, this.progData.filterWorker.getActFilterSettings().exactThemeProperty());
        this.cboTheme = new PCboString(this.progData.stringFilterLists.getFilterListTheme(), this.progData.filterWorker.getActFilterSettings().themeProperty(), supplierReportReturn);
        this.cboThemeTitle = new PCboString(this.progData.stringFilterLists.getFilterListThemeTitle(), this.progData.filterWorker.getActFilterSettings().themeTitleProperty(), supplierReportReturn);
        this.cboTitle = new PCboString(this.progData.stringFilterLists.getFilterListTitel(), this.progData.filterWorker.getActFilterSettings().titleProperty(), supplierReportReturn);
        this.cboSomewhere = new PCboString(this.progData.stringFilterLists.getFilterListSomewhere(), this.progData.filterWorker.getActFilterSettings().somewhereProperty(), supplierReportReturn);
        this.cboUrl = new PCboString(this.progData.stringFilterLists.getFilterListUrl(), this.progData.filterWorker.getActFilterSettings().urlProperty(), supplierReportReturn);
        this.setSpacing(10.0);
        this.addFilter();
    }

    private void addFilter() {
        this.addTxt("Sender", this.mbChannel, this, this.progData.filterWorker.getActFilterSettings().channelVisProperty());
        SimpleBooleanProperty b = new SimpleBooleanProperty();
        b.bind(this.progData.filterWorker.getActFilterSettings().themeVisProperty().and(this.progData.filterWorker.getActFilterSettings().themeIsExactProperty().not()));
        this.addTxt("Thema", this.cboTheme, this, b);
        b = new SimpleBooleanProperty();
        b.bind(this.progData.filterWorker.getActFilterSettings().themeVisProperty().and(this.progData.filterWorker.getActFilterSettings().themeIsExactProperty()));
        this.addTxt("Thema exakt", this.cboThemeExact, this, b);
        this.addTxt("Thema oder Titel", this.cboThemeTitle, this, this.progData.filterWorker.getActFilterSettings().themeTitleVisProperty());
        this.addTxt("Titel", this.cboTitle, this, this.progData.filterWorker.getActFilterSettings().titleVisProperty());
        this.addTxt("Irgendwo", this.cboSomewhere, this, this.progData.filterWorker.getActFilterSettings().somewhereVisProperty());
        this.addTxt("URL", this.cboUrl, this, this.progData.filterWorker.getActFilterSettings().urlVisProperty());
        Separator sp = new Separator();
        sp.getStyleClass().add("pseperator1");
        sp.setMinHeight(0.0);
        sp.setMaxHeight(1.0);
        this.getChildren().add(sp);
        this.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().channelVisProperty().or(this.progData.filterWorker.getActFilterSettings().themeVisProperty().or(this.progData.filterWorker.getActFilterSettings().themeTitleVisProperty().or(this.progData.filterWorker.getActFilterSettings().titleVisProperty().or(this.progData.filterWorker.getActFilterSettings().somewhereVisProperty().or(this.progData.filterWorker.getActFilterSettings().urlVisProperty()))))));
        this.managedProperty().bind(this.visibleProperty());
        sp.visibleProperty().bind(this.visibleProperty());
        sp.managedProperty().bind(this.visibleProperty());
    }

    private void addTxt(String txt, Node control, VBox vBoxComplete, BooleanProperty booleanProperty) {
        VBox vBox = new VBox(2.0);
        Label label = new Label(txt);
        vBox.getChildren().addAll((Node[])new Node[]{label, control});
        vBoxComplete.getChildren().add(vBox);
        vBox.visibleProperty().bind(booleanProperty);
        vBox.managedProperty().bind(booleanProperty);
    }
}

