/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.data.abo.AboListFactory;
import de.p2tools.mtplayer.controller.filmfilter.FilmFilter;
import de.p2tools.mtplayer.controller.filmfilter.FilterSamples;
import de.p2tools.mtplayer.gui.filter.FilmFilterDialog;
import de.p2tools.mtplayer.gui.filter.FilmFilterSortDialog;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.P2SeparatorComboBox;
import de.p2tools.p2lib.p2event.P2Listener;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class FilmFilterControllerProfiles
extends VBox {
    private final ComboBox<FilmFilter> cboFilterProfiles = new P2SeparatorComboBox<FilmFilter>();
    private final MenuButton mbFilterTools = new MenuButton("");
    private final Button btnLoadFilter = new Button("");
    private final Button btnSaveFilter = new Button("");
    private final Button btnNewFilter = new Button("");
    private final ProgData progData = ProgData.getInstance();

    public FilmFilterControllerProfiles() {
        this.setSpacing(10.0);
        this.initButton();
        this.filterProfiles();
        this.initRest();
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILTER_CHANGED){

            @Override
            public void pingGui() {
                FilmFilterControllerProfiles.this.checkCboFilter();
            }
        });
        this.checkCboFilter();
    }

    private void markFilterOk(boolean ok) {
        if (ok) {
            this.cboFilterProfiles.getStyleClass().removeAll((String[])new String[]{"markFilterOk"});
            this.cboFilterProfiles.getStyleClass().add("markFilterOk");
        } else {
            this.cboFilterProfiles.getStyleClass().removeAll((String[])new String[]{"markFilterOk"});
        }
    }

    private void initButton() {
        this.btnLoadFilter.setOnAction(a -> this.loadFilter());
        this.btnLoadFilter.disableProperty().bind(this.cboFilterProfiles.getSelectionModel().selectedItemProperty().isNull());
        this.btnLoadFilter.setGraphic(ProgIcons.ICON_FILTER_LOAD.getImageView());
        this.btnLoadFilter.setTooltip(new Tooltip("Filterprofil wieder laden"));
        this.btnSaveFilter.setOnAction(a -> {
            if (this.cboFilterProfiles.getSelectionModel().getSelectedItem() == null || P2Alert.showAlertOkCancel("Speichern", "Filterprofil speichern", "Soll das Filterprofil \u00fcberschrieben werden?")) {
                this.saveFilter();
            }
        });
        this.btnSaveFilter.setGraphic(ProgIcons.ICON_FILTER_SAVE.getImageView());
        this.btnSaveFilter.setTooltip(new Tooltip("Aktuelle Filtereinstellung als Filterprofil speichern"));
        this.btnNewFilter.setOnAction(a -> this.newFilter());
        this.btnNewFilter.setGraphic(ProgIcons.ICON_FILTER_NEW.getImageView());
        this.btnNewFilter.setTooltip(new Tooltip("Aktuelle Filtereinstellung als neues Filterprofil anlegen"));
    }

    private void filterProfiles() {
        this.cboFilterProfiles.setItems(this.progData.filterWorker.getFilmFilterList());
        this.cboFilterProfiles.setTooltip(new Tooltip("Gespeicherte Filterprofile k\u00f6nnen\nhier geladen werden"));
        MenuItem miLoad = new MenuItem("Aktuelles Filterprofil wieder laden");
        miLoad.setOnAction(e -> this.loadFilter());
        miLoad.disableProperty().bind(this.cboFilterProfiles.getSelectionModel().selectedItemProperty().isNull());
        MenuItem miRename = new MenuItem("Aktuelles Filterprofil umbenennen");
        miRename.setOnAction(e -> this.renameFilter());
        miRename.disableProperty().bind(this.cboFilterProfiles.getSelectionModel().selectedItemProperty().isNull());
        MenuItem miDel = new MenuItem("Aktuelles Filterprofil l\u00f6schen");
        miDel.setOnAction(e -> this.delFilter());
        miDel.disableProperty().bind(this.cboFilterProfiles.getSelectionModel().selectedItemProperty().isNull());
        MenuItem miDelAll = new MenuItem("Alle Filterprofile l\u00f6schen");
        miDelAll.setOnAction(e -> this.delAllFilter());
        miDelAll.disableProperty().bind(Bindings.size(this.cboFilterProfiles.getItems()).isEqualTo(0));
        MenuItem miSave = new MenuItem("Filtereinstellungen in aktuellem Filterprofil speichern");
        miSave.setOnAction(e -> this.saveFilter());
        miSave.disableProperty().bind(this.cboFilterProfiles.getSelectionModel().selectedItemProperty().isNull());
        MenuItem miNew = new MenuItem("Filtereinstellungen in neuem Filterprofil speichern");
        miNew.setOnAction(e -> this.newFilter());
        MenuItem miAbo = new MenuItem("Aus den Filtereinstellungen ein Abo erstellen");
        miAbo.setOnAction(a -> AboListFactory.addNewAboFromFilterButton());
        miAbo.disableProperty().bind(this.cboFilterProfiles.getSelectionModel().selectedItemProperty().isNull());
        MenuItem miResort = new MenuItem("Filterprofile sortieren");
        miResort.setOnAction(e -> new FilmFilterSortDialog(this.progData).showDialog());
        MenuItem miFilterDialog = new MenuItem("Filterprofile in eigenem Fenster anzeigen");
        miFilterDialog.setOnAction(e -> new FilmFilterDialog(this.progData).showDialog());
        MenuItem miAddStandard = new MenuItem("Standard-Filterprofile anh\u00e4ngen");
        miAddStandard.setOnAction(e -> this.resetFilter(false));
        MenuItem miReset = new MenuItem("Alle Filterprofile wieder herstellen");
        miReset.setOnAction(e -> this.resetFilter(true));
        this.mbFilterTools.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        this.mbFilterTools.getItems().addAll((MenuItem[])new MenuItem[]{miLoad, miRename, miDel, miDelAll, miSave, miNew, miAbo, new SeparatorMenuItem(), miResort, miFilterDialog, new SeparatorMenuItem(), miAddStandard, miReset});
        this.mbFilterTools.setTooltip(new Tooltip("Gespeicherte Filterprofile bearbeiten"));
        this.cboFilterProfiles.getSelectionModel().select(ProgConfig.FILTER_FILM_SEL_FILTER.get());
        ProgConfig.FILTER_FILM_SEL_FILTER.bind(this.cboFilterProfiles.getSelectionModel().selectedIndexProperty());
        this.cboFilterProfiles.valueProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue != null) {
                this.loadFilter();
            }
        });
        ProgConfig.SYSTEM_THEME_CHANGED.addListener((u, o, n) -> this.cboFilterProfiles.setCellFactory(new ListViewListCellCallback()));
        this.cboFilterProfiles.setCellFactory(new ListViewListCellCallback());
    }

    private void initRest() {
        HBox hBox = new HBox(5.0);
        this.btnLoadFilter.setMaxWidth(Double.MAX_VALUE);
        this.btnSaveFilter.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.btnLoadFilter, Priority.ALWAYS);
        HBox.setHgrow(this.btnSaveFilter, Priority.ALWAYS);
        hBox.getChildren().addAll((Node[])new Node[]{this.btnLoadFilter, this.btnNewFilter, this.btnSaveFilter});
        this.getChildren().add(hBox);
        this.cboFilterProfiles.setMaxWidth(Double.MAX_VALUE);
        VBox vBox = new VBox(2.0);
        vBox.getChildren().addAll((Node[])new Node[]{new Label("Filterprofile:"), this.cboFilterProfiles});
        this.getChildren().add(vBox);
        Button btnHelp = P2Button.helpButton("Filter", "Mit den Filterprofilen k\u00f6nnen Filtereinstellungen gespeichert und wieder abgerufen werden. Der Pfeil \"nach oben\" stellt den ausgew\u00e4hlten Filter ein, Der Pfeil \"nach unter\" schreibt die eingestellten Filter in das gew\u00e4hlte Filterprofil. Der \"Kreis\" speichert die aktuellen Filtereinstellungen in einem neuen Profil.\n\nSolange die Filtereinstellungen mit dem ausgew\u00e4hlten Profil \u00fcbereinstimmen, wird der Name des Profils unterstrichen.\n");
        hBox = new HBox(10.0);
        hBox.getChildren().addAll((Node[])new Node[]{this.mbFilterTools, P2GuiTools.getHBoxGrower(), btnHelp});
        this.getChildren().add(hBox);
    }

    private void loadFilter() {
        this.progData.filterWorker.setActFilterSettings((FilmFilter)this.cboFilterProfiles.getSelectionModel().getSelectedItem());
    }

    private void saveFilter() {
        FilmFilter sf = (FilmFilter)this.cboFilterProfiles.getSelectionModel().getSelectedItem();
        if (sf == null) {
            this.newFilter();
        } else {
            this.progData.filterWorker.getFilmFilterList().saveStoredFilter(sf);
            this.checkCboFilter();
        }
    }

    private void delFilter() {
        FilmFilter sf = (FilmFilter)this.cboFilterProfiles.getSelectionModel().getSelectedItem();
        if (sf == null) {
            P2Alert.showInfoNoSelection();
            return;
        }
        if (this.progData.filterWorker.getFilmFilterList().removeStoredFilter(sf)) {
            this.cboFilterProfiles.getSelectionModel().clearSelection();
        }
    }

    private void delAllFilter() {
        this.progData.filterWorker.getFilmFilterList().removeAllStoredFilter();
        this.cboFilterProfiles.getSelectionModel().clearSelection();
    }

    private void resetFilter(boolean replace) {
        if (replace) {
            if (!P2Alert.showAlertOkCancel("Zur\u00fccksetzen", "Filterprofile zur\u00fccksetzen", "Sollen alle Filterprofile gel\u00f6scht und durch die Profile vom ersten Programmstart ersetzt werden?")) {
                return;
            }
            this.progData.filterWorker.getFilmFilterList().clear();
        } else if (!this.progData.filterWorker.getFilmFilterList().isEmpty()) {
            this.progData.filterWorker.getFilmFilterList().add(new FilmFilter("=====<>====="));
            this.progData.filterWorker.getFilmFilterList().add(new FilmFilter("=====<>====="));
        }
        FilterSamples.addStandardFilter();
        this.cboFilterProfiles.getSelectionModel().selectFirst();
    }

    private void newFilter() {
        TextInputDialog dialog = new TextInputDialog(this.progData.filterWorker.getFilmFilterList().getNextName());
        dialog.setTitle("Filterprofilname");
        dialog.setHeaderText("Den Namen des Filterprofils vorgeben");
        dialog.setContentText("Name:");
        dialog.setResizable(true);
        dialog.initOwner(this.progData.primaryStage);
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            this.progData.filterWorker.getFilmFilterList().addNewStoredFilter((String)result.get());
            this.cboFilterProfiles.getSelectionModel().selectLast();
        }
    }

    private void renameFilter() {
        FilmFilter sf = (FilmFilter)this.cboFilterProfiles.getSelectionModel().getSelectedItem();
        if (sf == null) {
            return;
        }
        TextInputDialog dialog = new TextInputDialog(sf.getName());
        dialog.setTitle("Filterprofil umbenennen");
        dialog.setHeaderText("Den Namen des Filterprofils \u00e4ndern");
        dialog.setContentText("Neuer Name:");
        dialog.setResizable(true);
        dialog.initOwner(this.progData.primaryStage);
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            sf.setName((String)result.get());
            this.cboFilterProfiles.getSelectionModel().clearSelection();
            this.cboFilterProfiles.getSelectionModel().select(sf);
        }
    }

    private void checkCboFilter() {
        FilmFilter sfCbo;
        FilmFilter sf = this.progData.filterWorker.getActFilterSettings();
        if (sf.isSame(sfCbo = (FilmFilter)this.cboFilterProfiles.getSelectionModel().getSelectedItem())) {
            this.markFilterOk(true);
        } else {
            this.markFilterOk(false);
        }
    }

    private static class ListViewListCellCallback
    implements Callback<ListView<FilmFilter>, ListCell<FilmFilter>> {
        private ListViewListCellCallback() {
        }

        @Override
        public ListCell<FilmFilter> call(ListView<FilmFilter> param) {
            return new ListCell<FilmFilter>(){

                @Override
                public void updateItem(FilmFilter item, boolean empty) {
                    super.updateItem(item, empty);
                    if (item == null || empty) {
                        this.setGraphic(null);
                        this.setText(null);
                        this.setStyle("");
                        return;
                    }
                    if (P2SeparatorComboBox.isSeparator(item.toString())) {
                        this.setGraphic(ProgIcons.ICON_BUTTON_SEPARATOR_WIDTH.getImageView());
                        this.setText(null);
                        this.setStyle("-fx-alignment: center;");
                        this.setDisable(true);
                    } else {
                        this.setGraphic(null);
                        this.setText(item.toString());
                        this.setStyle("");
                        this.setDisable(false);
                    }
                }
            };
        }
    }
}

