/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.p2lib.guitools.P2LDatePicker;
import de.p2tools.p2lib.guitools.pcheckcombobox.P2CheckComboBox;
import de.p2tools.p2lib.guitools.prange.P2RangeBox;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class FilmFilterControllerFilter
extends VBox {
    private final Slider slTimeRange = new Slider();
    private final Label lblTimeRange = new Label("Zeitraum:");
    private final Label lblTimeRangeValue = new Label();
    private final P2RangeBox slDur = new P2RangeBox("Filml\u00e4nge:", true, 0, 150);
    private final P2RangeBox slTime = new P2RangeBox("Sendezeit:", true, 0, 86400);
    private final P2ToggleSwitch tglFilmTime = new P2ToggleSwitch("Zeitraum ausschlie\u00dfen");
    private final Label lblShowDate = new Label("Sendedatum:");
    private final P2LDatePicker pDatePicker = new P2LDatePicker();
    private final Button btnClearDatePicker = new Button("");
    private final ProgData progData = ProgData.getInstance();

    public FilmFilterControllerFilter() {
        this.setSpacing(10.0);
        this.addSlider();
        this.addCheckFilter();
    }

    private void initDaysFilter() {
        this.slTimeRange.setMin(0.0);
        this.slTimeRange.setMax(50.0);
        this.slTimeRange.setShowTickLabels(true);
        this.slTimeRange.setMajorTickUnit(10.0);
        this.slTimeRange.setBlockIncrement(5.0);
        this.slTimeRange.setLabelFormatter(new StringConverter<Double>(){

            @Override
            public String toString(Double x) {
                if (x == 0.0) {
                    return "alles";
                }
                return "" + x.intValue();
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
        this.slTimeRange.setValue(this.progData.filterWorker.getActFilterSettings().getTimeRange());
        this.setLabelSlider();
        this.progData.filterWorker.getActFilterSettings().timeRangeProperty().addListener(l -> this.slTimeRange.setValue(this.progData.filterWorker.getActFilterSettings().getTimeRange()));
        this.slTimeRange.valueProperty().addListener((o, oldV, newV) -> {
            this.setLabelSlider();
            if (!this.slTimeRange.isValueChanging()) {
                this.progData.filterWorker.getActFilterSettings().setTimeRange((int)this.slTimeRange.getValue());
            }
        });
        this.slTimeRange.valueChangingProperty().addListener((observable2, oldvalue, newvalue) -> {
            if (!newvalue.booleanValue()) {
                this.progData.filterWorker.getActFilterSettings().setTimeRange((int)this.slTimeRange.getValue());
            }
        });
    }

    private void initDurFilter() {
        this.slDur.minValueProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().minDurProperty());
        this.slDur.maxValueProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().maxDurProperty());
    }

    private void initFilmTimeAndDateFilter() {
        this.slTime.set24h();
        this.slTime.minValueProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().minTimeProperty());
        this.slTime.maxValueProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().maxTimeProperty());
        this.tglFilmTime.selectedProperty().bindBidirectional(this.progData.filterWorker.getActFilterSettings().minMaxTimeInvertProperty());
        this.pDatePicker.valueProperty().addListener((u, o, n) -> {
            LocalDate newDate = this.pDatePicker.getDateLDate();
            if (newDate != null) {
                try {
                    this.progData.filterWorker.getActFilterSettings().setShowDate(P2LDateFactory.toString(newDate));
                }
                catch (Exception ex) {
                    this.progData.filterWorker.getActFilterSettings().setShowDate("");
                }
            } else {
                this.progData.filterWorker.getActFilterSettings().setShowDate("");
            }
        });
        this.progData.filterWorker.getActFilterSettings().showDateProperty().addListener((observable2, oldValue, newValue) -> this.initPDatePicker());
        this.initPDatePicker();
        this.btnClearDatePicker.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        this.btnClearDatePicker.setOnAction(a -> this.pDatePicker.clearDate());
    }

    private void initPDatePicker() {
        try {
            String s = this.progData.filterWorker.getActFilterSettings().getShowDate();
            if (!P2LDateFactory.fromString(s).equals(LocalDate.MIN) && !s.isEmpty()) {
                LocalDate localDate = P2LDateFactory.fromString(this.progData.filterWorker.getActFilterSettings().getShowDate());
                this.pDatePicker.setValue(localDate);
            } else {
                this.pDatePicker.clearDate();
            }
        }
        catch (DateTimeParseException ex) {
            this.pDatePicker.clearDate();
        }
    }

    private void addSlider() {
        this.initDaysFilter();
        this.initDurFilter();
        this.initFilmTimeAndDateFilter();
        VBox vBox = new VBox(2.0);
        HBox h = new HBox();
        HBox hh = new HBox();
        h.getChildren().addAll((Node[])new Node[]{this.lblTimeRange, hh, this.lblTimeRangeValue});
        HBox.setHgrow(hh, Priority.ALWAYS);
        this.lblTimeRange.setMinWidth(0.0);
        vBox.getChildren().addAll((Node[])new Node[]{h, this.slTimeRange});
        vBox.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().timeRangeVisProperty());
        vBox.managedProperty().bind(this.progData.filterWorker.getActFilterSettings().timeRangeVisProperty());
        this.getChildren().addAll((Node[])new Node[]{vBox});
        this.slDur.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().minMaxDurVisProperty());
        this.slDur.managedProperty().bind(this.progData.filterWorker.getActFilterSettings().minMaxDurVisProperty());
        this.getChildren().addAll((Node[])new Node[]{this.slDur});
        vBox = new VBox(2.0);
        vBox.getChildren().addAll((Node[])new Node[]{this.slTime, this.tglFilmTime});
        vBox.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().minMaxTimeVisProperty());
        vBox.managedProperty().bind(this.progData.filterWorker.getActFilterSettings().minMaxTimeVisProperty());
        this.getChildren().addAll((Node[])new Node[]{vBox});
        vBox = new VBox(2.0);
        HBox hBox = new HBox(5.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{this.pDatePicker, this.btnClearDatePicker});
        HBox.setHgrow(this.pDatePicker, Priority.ALWAYS);
        this.pDatePicker.setMaxWidth(Double.MAX_VALUE);
        vBox.getChildren().addAll((Node[])new Node[]{this.lblShowDate, hBox});
        vBox.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().showDateVisProperty());
        vBox.managedProperty().bind(this.progData.filterWorker.getActFilterSettings().showDateVisProperty());
        this.getChildren().addAll((Node[])new Node[]{vBox});
    }

    private void addCheckFilter() {
        P2CheckComboBox checkOnly = new P2CheckComboBox();
        P2CheckComboBox checkNot = new P2CheckComboBox();
        Label lblOnly = new Label("Anzeigen:");
        Label lblNot = new Label("Ausschlie\u00dfen:");
        String ONLY_BOOKMARK = "Bookmarks";
        String ONLY_HD = "HD";
        String ONLY_UT = "UT";
        String ONLY_MARK = "Markiert";
        String ONLY_NEW = "Neue";
        String ONLY_LIVE = "Livestreams";
        String ONLY_AKT_HISTORY = "Aktuelle History";
        String NOT_ABO = "Abos";
        String NOT_HISTORY = "Gesehene";
        String NOT_DOUBLE = "Doppelte";
        String NOT_GEO = "Geo geblockt";
        String NOT_FUTURE = "Zukunft";
        checkOnly.setEmptyText("Alles");
        checkOnly.addItem("Bookmarks", "Nur Filme der Bookmarks anzeigen", this.progData.filterWorker.getActFilterSettings().onlyBookmarkProperty());
        checkOnly.addItem("HD", "Nur HD-Filme anzeigen", this.progData.filterWorker.getActFilterSettings().onlyHdProperty());
        checkOnly.addItem("UT", "Nur Filme mit Untertitel anzeigen", this.progData.filterWorker.getActFilterSettings().onlyUtProperty());
        checkOnly.addItem("Markiert", "Nur markierte Filme anzeigen", this.progData.filterWorker.getActFilterSettings().onlyMarkProperty());
        checkOnly.addItem("Neue", "Nur neue Filme anzeigen", this.progData.filterWorker.getActFilterSettings().onlyNewProperty());
        checkOnly.addItem("Livestreams", "Nur Livestreams anzeigen", this.progData.filterWorker.getActFilterSettings().onlyLiveProperty());
        checkOnly.addItem("Aktuelle History", "Nur die aktuelle History anzeigen", this.progData.filterWorker.getActFilterSettings().onlyActHistoryProperty());
        checkNot.setEmptyText("Nichts");
        checkNot.addItem("Abos", "Keine Filme f\u00fcr die es ein Abo gibt, anzeigen", this.progData.filterWorker.getActFilterSettings().notAboProperty());
        checkNot.addItem("Gesehene", "Bereits gesehene Filme nicht anzeigen", this.progData.filterWorker.getActFilterSettings().notHistoryProperty());
        checkNot.addItem("Doppelte", "Doppelte Filme nur einmal anzeigen", this.progData.filterWorker.getActFilterSettings().notDoubleProperty());
        checkNot.addItem("Geo geblockt", "Geo-geblockte Filme nicht anzeigen", this.progData.filterWorker.getActFilterSettings().notGeoProperty());
        checkNot.addItem("Zukunft", "Keine Filme mit Datum in der Zukunft anzeigen", this.progData.filterWorker.getActFilterSettings().notFutureProperty());
        VBox vBox = new VBox(2.0);
        vBox.getChildren().addAll((Node[])new Node[]{lblOnly, checkOnly});
        vBox.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().onlyVisProperty());
        vBox.managedProperty().bind(this.progData.filterWorker.getActFilterSettings().onlyVisProperty());
        this.getChildren().add(vBox);
        vBox = new VBox(2.0);
        vBox.getChildren().addAll((Node[])new Node[]{lblNot, checkNot});
        vBox.visibleProperty().bind(this.progData.filterWorker.getActFilterSettings().notVisProperty());
        vBox.managedProperty().bind(this.progData.filterWorker.getActFilterSettings().notVisProperty());
        this.getChildren().add(vBox);
    }

    private void setLabelSlider() {
        String txtAll = "Alles";
        int i = (int)this.slTimeRange.getValue();
        String tNr = "" + i;
        if (i == 0) {
            this.lblTimeRangeValue.setText("Alles");
        } else {
            this.lblTimeRangeValue.setText(tNr + (i == 1 ? " Tag" : " Tage"));
        }
    }
}

