/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.filter;

import de.p2tools.mtplayer.controller.config.PShortcut;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.gui.configdialog.ConfigDialogController;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class FilmFilterControllerBlacklist
extends HBox {
    private final ProgData progData;
    private final P2ToggleSwitch tglBlacklist = new P2ToggleSwitch("Blacklist:");

    public FilmFilterControllerBlacklist() {
        this.progData = ProgData.getInstance();
        Button btnBlack = new Button("");
        btnBlack.getStyleClass().add("buttonSmall");
        btnBlack.setGraphic(ProgIcons.ICON_BUTTON_EDIT.getImageView());
        btnBlack.setOnAction(a -> new ConfigDialogController(ProgData.getInstance(), true));
        btnBlack.disableProperty().bind(ConfigDialogController.dialogIsRunning);
        btnBlack.setTooltip(new Tooltip("Blacklist-Einstellungen anzeigen - " + PShortcut.SHORTCUT_ADD_BLACKLIST_THEME.getActShortcut()));
        Label lblRight = new Label();
        this.tglBlacklist.setAllowIndeterminate(true);
        this.tglBlacklist.setLabelLeft("Blacklist [ein]:", "Blacklist [aus]:", "Blacklist [invers]:");
        this.tglBlacklist.setTooltip(new Tooltip("Blacklist aus: Alle Filme werden angezeigt.\nBlacklist ein: Von der Blacklist erfasste Filme werden nicht angezeigt.\nBlacklist invers: Nur von der Blacklist erfasste Filme werden angezeigt."));
        this.setTglBlacklist();
        this.progData.filterWorker.getActFilterSettings().blacklistOnOffProperty().addListener((u, o, n) -> this.setTglBlacklist());
        this.tglBlacklist.getCheckBox().setOnAction(mouseEvent -> {
            if (this.tglBlacklist.isIndeterminate()) {
                this.progData.filterWorker.getActFilterSettings().setBlacklistOnOff(2);
            } else if (this.tglBlacklist.isSelected()) {
                this.progData.filterWorker.getActFilterSettings().setBlacklistOnOff(1);
            } else {
                this.progData.filterWorker.getActFilterSettings().setBlacklistOnOff(0);
            }
        });
        this.setSpacing(5.0);
        this.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow(this.tglBlacklist, Priority.ALWAYS);
        this.getChildren().addAll((Node[])new Node[]{this.tglBlacklist, lblRight, btnBlack});
    }

    private void setTglBlacklist() {
        switch (this.progData.filterWorker.getActFilterSettings().blacklistOnOffProperty().getValue()) {
            case 0: {
                this.tglBlacklist.setIndeterminate(false);
                this.tglBlacklist.setSelected(false);
                break;
            }
            case 1: {
                this.tglBlacklist.setIndeterminate(false);
                this.tglBlacklist.setSelected(true);
                break;
            }
            case 2: {
                this.tglBlacklist.setIndeterminate(true);
                this.tglBlacklist.setSelected(false);
            }
        }
    }
}

